/*
 * Decompiled with CFR 0.152.
 */
package de.tudresden.sumo.util;

import de.tudresden.sumo.util.SumoCommand;
import de.tudresden.ws.conf.Config;
import de.tudresden.ws.log.Log;
import it.polito.appeal.traci.SumoTraciConnection;
import java.util.Map;
import java.util.Set;

public class Sumo {
    Log logger;
    Config conf;
    public SumoTraciConnection conn;
    boolean running = false;

    public Sumo() {
    }

    public Sumo(Config config) {
        this.conf = config;
    }

    public void start(String string, String string2) {
        this.conn = new SumoTraciConnection(string, string2);
        try {
            this.conn.runServer();
            this.running = true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.running = false;
        }
    }

    public void start(String string, String string2, String string3) {
        this.conn = new SumoTraciConnection(string, string2, string3);
        try {
            this.conn.runServer();
            this.running = true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.running = false;
        }
    }

    public boolean set_cmd(Object object) {
        boolean bl = false;
        if (this.running) {
            try {
                this.conn.do_job_set((SumoCommand)object);
                bl = true;
            }
            catch (Exception exception) {
                this.logger.write(exception.getStackTrace());
            }
        }
        return bl;
    }

    public Object get_cmd(SumoCommand sumoCommand) {
        Object object = -1;
        if (this.running) {
            try {
                object = this.conn.do_job_get(sumoCommand);
            }
            catch (Exception exception) {
                this.logger.write(exception.getStackTrace());
            }
        }
        return object;
    }

    public void do_timestep() {
        try {
            this.conn.do_timestep();
        }
        catch (Exception exception) {
            this.logger.write(exception.getStackTrace());
        }
    }

    public void start_ws() {
        this.conn = new SumoTraciConnection(Config.sumo_bin, Config.config_file);
        this.add_options();
        try {
            this.conn.runServer();
            this.running = true;
        }
        catch (Exception exception) {
            this.logger.write(exception.getStackTrace());
            this.running = false;
        }
    }

    private void add_options() {
        Set<Map.Entry<String, String>> set = this.conf.sumo_output.entrySet();
        for (Map.Entry<String, String> entry : set) {
            this.conn.addOption(entry.getKey(), entry.getValue());
        }
    }

    public void stop_instance() {
        try {
            this.conn.close();
            this.running = false;
        }
        catch (Exception exception) {
            this.logger.write(exception.getStackTrace());
        }
    }
}

