/*
 * Decompiled with CFR 0.152.
 */
package it.polito.appeal.traci.protocol;

import de.uniluebeck.itm.tcpip.Storage;

public class Command {
    private static final int HEADER_SIZE = 6;
    private final int id;
    private final Storage content;

    public Command(Storage storage) {
        int n = storage.readUnsignedByte();
        n = n == 0 ? storage.readInt() - 6 : (n -= 2);
        this.id = storage.readUnsignedByte();
        short[] sArray = new short[n];
        for (int i = 0; i < n; ++i) {
            sArray[i] = (byte)storage.readUnsignedByte();
        }
        this.content = new Storage(sArray);
    }

    public Command(int n) {
        if (n > 255) {
            throw new IllegalArgumentException("id should fit in a byte");
        }
        this.content = new Storage();
        this.id = n;
    }

    public int id() {
        return this.id;
    }

    public Storage content() {
        return this.content;
    }

    public void writeRawTo(Storage storage) {
        storage.writeByte(0);
        storage.writeInt(6 + this.content.size());
        storage.writeUnsignedByte(this.id);
        for (Byte by : this.content.getStorageList()) {
            storage.writeByte(by.byteValue());
        }
    }

    public int rawSize() {
        return 6 + this.content.size();
    }
}

