/*
 * Decompiled with CFR 0.152.
 */
package it.polito.appeal.traci.protocol;

import de.uniluebeck.itm.tcpip.Storage;
import it.polito.appeal.traci.protocol.Command;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.zip.Checksum;

public class RequestMessage {
    private final List<Command> commands = new ArrayList<Command>();

    public void append(Command command) {
        if (command == null) {
            throw new NullPointerException("the command can't be null");
        }
        this.commands.add(command);
    }

    public void writeTo(DataOutputStream dataOutputStream) throws IOException {
        int n = 4;
        for (Command object : this.commands) {
            n += object.rawSize();
        }
        Iterator<Command> iterator = null;
        dataOutputStream.writeInt(n);
        for (Command command : this.commands) {
            Storage storage = new Storage();
            command.writeRawTo(storage);
            this.writeStorage(storage, dataOutputStream, (Checksum)((Object)iterator));
        }
    }

    private void writeStorage(Storage storage, OutputStream outputStream, Checksum checksum) throws IOException {
        byte[] byArray = new byte[storage.getStorageList().size()];
        int n = 0;
        for (Byte by : storage.getStorageList()) {
            if (checksum != null) {
                checksum.update(by.byteValue());
            }
            byArray[n] = by;
            ++n;
        }
        outputStream.write(byArray);
    }

    public List<Command> commands() {
        return Collections.unmodifiableList(this.commands);
    }
}

