package de.tudresden.simulation;
import de.tudresden.sumo.cmd.Gui;
import de.tudresden.sumo.cmd.Vehicle;
import de.tudresden.ws.container.SumoPosition3D;
import it.polito.appeal.traci.SumoTraciConnection;


public class Main {

	static String sumo_bin = "/scratch/sumo-code/sumo/bin/sumo-gui";
	static String config_file = "simulation/san_francisco.sumo.cfg";
	static double step_length = 1;		
	
	public static void main(String[] args) {
	
		try{
			
			SumoTraciConnection conn = new SumoTraciConnection(sumo_bin, config_file);
			conn.addOption("step-length", step_length+"");
			
			//start TraCI Server
			conn.runServer();
			
			conn.do_job_set(Vehicle.add("demo", "car", "r1", 0, 0, 13.8, (byte) 1));
			conn.do_job_set(Gui.trackVehicle("View #0", "demo"));
			conn.do_job_set(Gui.setZoom("View #0", 24281));
			
			for(int i=0; i<720; i++){
			
				conn.do_timestep();
				
				double pos1 = (Double) conn.do_job_get(Vehicle.getDistance("demo"));
				SumoPosition3D pos = (SumoPosition3D) conn.do_job_get(Vehicle.getPosition3D("demo"));
				System.out.println(i+";"+pos1+";"+pos.z);
				
			}
			 
			conn.close();
			
		}catch(Exception ex){ex.printStackTrace();}

		//plot the generated data with gnuplot e.g. 'gnuplot plotter'
		
	}

}
