/*
 * Decompiled with CFR 0.152.
 */
package de.dlr.ts.commons.logger;

import de.dlr.ts.commons.utils.print.Color;
import de.dlr.ts.commons.utils.print.ColorString;
import de.dlr.ts.commons.utils.print.Effect;
import java.util.ArrayList;
import java.util.List;

public class MyString {
    private List<Component> components = new ArrayList<Component>();

    public static MyString create() {
        return new MyString();
    }

    public static MyString create(String text) {
        return new MyString(text);
    }

    public static MyString create(String text, Color color) {
        return new MyString(text, color);
    }

    public MyString() {
    }

    public MyString(String text) {
        this.components.add(new Component(text));
    }

    public MyString(String text, Color color) {
        if (color == Color.NONE || color == null) {
            this.components.add(new Component(text));
        } else {
            this.components.add(new Component(text, color));
        }
    }

    public MyString string(String text) {
        this.components.add(new Component(text));
        return this;
    }

    public MyString red(String text) {
        this.components.add(new Component(text, Color.RED));
        return this;
    }

    public MyString green(String text) {
        this.components.add(new Component(text, Color.GREEN));
        return this;
    }

    public MyString yellow(String text) {
        this.components.add(new Component(text, Color.YELLOW));
        return this;
    }

    public MyString cyan(String text) {
        this.components.add(new Component(text, Color.CYAN));
        return this;
    }

    public MyString magenta(String text) {
        this.components.add(new Component(text, Color.MAGENTA));
        return this;
    }

    public MyString orange(String text) {
        this.components.add(new Component(text, Color.ORANGE));
        return this;
    }

    public MyString blue(String text) {
        this.components.add(new Component(text, Color.BLUE));
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Component c : this.components) {
            if (c.color != null) {
                sb.append(ColorString.string(c.text, c.color, Effect.BOLD));
                continue;
            }
            sb.append(c.text);
        }
        return sb.toString();
    }

    public String getPlainString() {
        StringBuilder sb = new StringBuilder();
        for (Component c : this.components) {
            sb.append(c.text);
        }
        return sb.toString();
    }

    private class Component {
        String text;
        Color color = null;

        public Component(String text) {
            this.text = text;
        }

        public Component(String text, Color color) {
            this(text);
            this.color = color;
        }
    }
}

