/*
 * Decompiled with CFR 0.152.
 */
package de.dlr.ts.commons.tools;

public class BytesTools {
    public static byte[] getBytes(long number) {
        byte[] b = new byte[8];
        for (int i = 0; i < 8; ++i) {
            b[i] = BytesTools.getByte(number, i);
        }
        return b;
    }

    public static boolean getBit(byte b, int index) {
        return ((b = (byte)(b >> index)) & 1) == 1;
    }

    public static String bytesToHex(byte[] array) {
        StringBuilder builder = new StringBuilder();
        for (byte b : array) {
            builder.append(String.format("%02x", b));
        }
        return "0x" + builder.toString();
    }

    public static byte[] getBytes(int number) {
        int size = 4;
        byte[] b = new byte[size];
        for (int i = 0; i < size; ++i) {
            b[i] = BytesTools.getByte(number, i);
        }
        return b;
    }

    public static byte[] getBytes(short value) {
        byte[] b = new byte[]{BytesTools.getByte(value, 0), BytesTools.getByte(value, 1)};
        return b;
    }

    public static byte getByte(long number, int index) {
        if (index > 7) {
            throw new IllegalArgumentException();
        }
        return (byte)((number >>>= index * 8) & 0xFFL);
    }

    public static byte getByte(short number, int index) {
        if (index > 1) {
            throw new IllegalArgumentException();
        }
        if (index == 0) {
            return (byte)(number & 0xFF);
        }
        int tmp = number;
        return (byte)((tmp >>>= 8) & 0xFF);
    }

    public static byte[] hexStringToBytes(String binaryString) {
        if (binaryString.startsWith("0x")) {
            binaryString = binaryString.replaceFirst("0x", "");
        }
        int len = binaryString.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(binaryString.charAt(i), 16) << 4) + Character.digit(binaryString.charAt(i + 1), 16));
        }
        return data;
    }

    public static long getMaskOfZeros(int length, int offset) {
        long temp = BytesTools.getMaskOfOnes(length, 0);
        long mask = -1L;
        temp ^= mask;
        for (int i = 0; i < offset; ++i) {
            temp <<= 1;
            ++temp;
        }
        return temp;
    }

    public static long getMaskOfOnes(int length, int offset) {
        long l = 0L;
        long mask = 1L;
        for (int i = 0; i < length; ++i) {
            l += mask;
            mask <<= 1;
        }
        return l << offset;
    }

    public static long bytesToLong(byte ... bytes) {
        long ret = 0L;
        for (int i = 0; i < bytes.length; ++i) {
            long temp = bytes[i] & 0xFF;
            if (i > 0) {
                temp <<= 8 * i;
            }
            ret += temp;
        }
        return ret;
    }

    public static byte[] invert(byte ... bytes) {
        byte[] a = new byte[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            a[i] = bytes[bytes.length - 1 - i];
        }
        return a;
    }

    public static long swapEndianness(long value) {
        return BytesTools.bytesToLong(BytesTools.invert(BytesTools.getBytes(value)));
    }

    public static int swapEndianness(int value) {
        return BytesTools.bytesToInt(BytesTools.invert(BytesTools.getBytes(value)));
    }

    public static short swapEndianness(short value) {
        return BytesTools.bytesToShort(BytesTools.invert(BytesTools.getBytes(value)));
    }

    public static short bytesToShort(byte ... bytes) {
        int end = 0;
        for (int i = 0; i < bytes.length; ++i) {
            int help = bytes[i] & 0xFF;
            end += (help <<= 8 * i);
        }
        return (short)end;
    }

    public static int bytesToInt(byte ... bytes) {
        int end = 0;
        for (int i = 0; i < bytes.length; ++i) {
            int help = bytes[i] & 0xFF;
            end += (help <<= 8 * i);
        }
        return end;
    }

    private static int bytesToInt2(byte ... bytes) {
        int end = 0;
        for (int i = 0; i < bytes.length; ++i) {
            int help = bytes[i] & 0xFF;
            if (i > 0) {
                help <<= 8 * i;
            }
            end += help;
        }
        return end;
    }

    public static void main2(String[] args) {
        byte[] aa = new byte[]{1, 0, 0};
        byte[] invert = BytesTools.invert(aa);
        for (int i = 0; i < invert.length; ++i) {
            System.out.println("# " + invert[i]);
        }
    }

    public static String byteToBinaryString(byte data) {
        StringBuilder sb = new StringBuilder();
        int un = data & 0xFF;
        for (int i = 7; i >= 0; --i) {
            int aa = un >> i & 1;
            if (aa == 0) {
                sb.append("0");
                continue;
            }
            sb.append("1");
        }
        return sb.toString();
    }

    public static String longToBinaryString(long data) {
        StringBuilder sb = new StringBuilder();
        for (int i = 63; i >= 0; --i) {
            long aa = data >>> i & 1L;
            if (aa == 0L) {
                sb.append("0");
                continue;
            }
            sb.append("1");
        }
        return sb.toString();
    }

    public static String bytesToBinaryString(byte ... b) {
        String ret = "";
        for (int i = 0; i < b.length; ++i) {
            ret = ret + BytesTools.byteToBinaryString(b[i]);
            if (i == b.length - 1) continue;
            ret = ret + "-";
        }
        return ret;
    }
}

