/*
 * Decompiled with CFR 0.152.
 */
package de.dlr.ts.commons.tools;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class DLRProperties {
    private List<Property> props = new ArrayList<Property>();

    public void loadXML(String xmlFileName) {
        Properties ss = new Properties();
    }

    public String getProperty(String key) {
        return this.getProperty(key, null);
    }

    public String getProperty(String key, String defaultValue) {
        for (Property property : this.props) {
            if (!property.name.equals(key)) continue;
            return property.value;
        }
        return defaultValue;
    }

    public long getProperty(String key, long defaultValue) {
        return Long.valueOf(this.getProperty(key, String.valueOf(defaultValue)));
    }

    public boolean getProperty(String key, boolean defaultValue) {
        return Boolean.valueOf(this.getProperty(key, String.valueOf(defaultValue)));
    }

    public int getProperty(String key, int defaultValue) {
        return Integer.valueOf(this.getProperty(key, String.valueOf(defaultValue)));
    }

    public void load(String ... args) {
        if (args == null) {
            return;
        }
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].startsWith("-")) continue;
            String value = i + 1 < args.length ? args[i + 1] : "true";
            if (value.startsWith("-")) {
                value = "true";
            }
            this.props.add(new Property(args[i], value));
        }
    }

    public void setProperty(String name, String value) {
        this.props.add(new Property(name, value));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Property p : this.props) {
            sb.append(p);
            sb.append(System.lineSeparator());
        }
        return sb.toString();
    }

    class Property {
        String name;
        String value;

        public Property(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String toString() {
            return this.name + " = " + this.value;
        }
    }
}

