/*
 * Decompiled with CFR 0.152.
 */
package de.dlr.ts.commons.utils.print;

import de.dlr.ts.commons.utils.print.Color;
import de.dlr.ts.commons.utils.print.Effect;

public class ColorString {
    private String text;
    private Color fore;
    private Color back;
    private Effect[] effects;
    private static String os = System.getProperty("os.name").toLowerCase().contains("win") ? "win" : "linux";

    public ColorString() {
    }

    public ColorString(String text) {
        this.text = text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setBackground(Color back) {
        this.back = back;
    }

    public ColorString(String text, Color fore, Effect ... effects) {
        this.text = text;
        this.fore = fore;
        this.effects = effects;
    }

    public ColorString(int text, Color fore, Effect ... effects) {
        this.text = "" + text;
        this.fore = fore;
        this.effects = effects;
    }

    public static ColorString instance(String text, Color fore, Effect ... effects) {
        return new ColorString(text, fore, effects);
    }

    public static String string(String text, Color fore, Effect ... effects) {
        return new ColorString(text, fore, effects).toString();
    }

    public static String string(int text, Color fore, Effect ... effects) {
        return new ColorString("" + text, fore, effects).toString();
    }

    public ColorString(String string, Color fore, Color back, Effect ... effects) {
        this(string, fore, effects);
        this.back = back;
    }

    public String getRawString() {
        return this.text;
    }

    public int getRawLength() {
        return this.text.length();
    }

    public int getOverheadLength() {
        return this.toString().length() - this.text.length();
    }

    public String toString() {
        return this.tint(this.text, this.fore, this.effects);
    }

    private String tint(String text, Color fore, Effect ... effects) {
        if (os.equals("win")) {
            return text;
        }
        String tail = "m" + text + "\u001b[0m";
        String header = "\u001b[";
        if (fore != null && !fore.equals((Object)Color.NONE)) {
            header = header + fore.getForegroundCode();
        }
        if (effects != null) {
            String eff = "";
            for (Effect e : effects) {
                eff = eff + ";" + e.getCode();
            }
            header = header + eff;
        }
        if (this.back != null) {
            header = header + ";" + this.back.getBackgroundCode();
        }
        return header + tail;
    }
}

