/*
 * Decompiled with CFR 0.152.
 */
package de.dlr.ts.lisum;

import de.dlr.ts.commons.tools.StringTools;
import de.dlr.ts.commons.utils.print.Color;
import de.dlr.ts.commons.utils.print.ColorString;
import de.dlr.ts.commons.utils.print.Effect;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

public class SplashScreen {
    private String programName = "";
    private String author = "";
    private String email = "";
    private String organization = "DLR";
    private int year = 2015;
    private List<String> comments = new ArrayList<String>();
    private List<Property> props = new ArrayList<Property>();
    private List<RuntimeOption> options = new ArrayList<RuntimeOption>();
    private long waitingTime = 0L;
    private int splashWidth = 80;
    private final String STARS_LINE = StringTools.repeatChar("*", this.splashWidth);
    private final String STARS_LINE_SHORT = "**";
    private boolean showCopyright = false;

    public void setShowCopyright(boolean showCopyright) {
        this.showCopyright = showCopyright;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setOrganization(String organization) {
        this.organization = organization;
    }

    public void setYear(int year) {
        this.year = year;
    }

    public SplashScreen(String programName) {
        this.programName = programName;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public void addRuntimeOption(String modificator, String variable, String defaultValue) {
        RuntimeOption r = new RuntimeOption();
        r.modificator = modificator;
        r.variable = variable == null ? "" : variable;
        r.defaultValue = defaultValue;
        this.options.add(r);
    }

    public void addProperty(String name, String value) {
        this.props.add(new Property(name, value));
    }

    public void addProperty(String name, double value) {
        this.props.add(new Property(name, String.valueOf(value)));
    }

    public void addProperty(String name, long value) {
        this.props.add(new Property(name, String.valueOf(value)));
    }

    public void addProperty(String name, int value) {
        this.props.add(new Property(name, String.valueOf(value)));
    }

    public void addProperty(String name, boolean value) {
        this.props.add(new Property(name, String.valueOf(value)));
    }

    private String getFormattedTitle(String title, Color color) {
        ColorString cs = new ColorString(title, color, Effect.BOLD, Effect.UNDERLINE);
        return StringTools.centerText(cs.toString(), this.splashWidth + cs.getOverheadLength(), "**");
    }

    private String getFormattedAuthor(String author, Color color) {
        ColorString label = new ColorString("Author: ", Color.WHITE, Effect.BOLD);
        return StringTools.alignLeft(label.toString() + author + " <" + this.email + ">", this.splashWidth + label.getOverheadLength(), "**");
    }

    public void setSplashScreenTime(long millis) {
        this.waitingTime = millis;
    }

    public void addComment(String comment) {
        this.comments.add(StringTools.alignLeft(comment, this.splashWidth, "**"));
    }

    public void showSplashScreen() {
        System.out.println(this.getSplashScreen());
        if (this.waitingTime > 0L) {
            this.waitForEnter();
        }
    }

    private void animation() {
        char[] animationChars = new char[]{'|', '/', '-', '\\'};
        for (int i = (int)(this.waitingTime / 1000L); i >= 0; --i) {
            System.out.print("Starting in " + i + " seconds " + animationChars[i % 4] + "\r");
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        System.out.println("Starting " + this.programName + "!");
    }

    private void waitForEnter() {
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        long startTime = System.currentTimeMillis();
        try {
            while (System.currentTimeMillis() - startTime < this.waitingTime && !in.ready()) {
                System.out.print("Press enter to start or wait " + (this.waitingTime / 1000L - (System.currentTimeMillis() - startTime) / 1000L - 1L) + " seconds\r");
                Thread.sleep(500L);
            }
        }
        catch (InterruptedException interruptedException) {
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        System.out.println("\r");
        System.out.println("Program started!");
    }

    public void newBlankLine() {
        this.comments.add(System.lineSeparator());
    }

    public void newCommentsLine() {
        this.comments.add("**");
    }

    public void newLineWithStars() {
        this.comments.add(this.STARS_LINE);
    }

    private void addCopyRight(StringBuilder sb) {
        sb.append(this.STARS_LINE).append(System.lineSeparator());
        sb.append(this.STARS_LINE).append(System.lineSeparator());
        sb.append(StringTools.alignLeft("Copyright (C) " + this.year, this.splashWidth, "**")).append(System.lineSeparator());
        sb.append(StringTools.alignLeft("Deutsches Zentrum fuer Luft- und Raumfahrt e.V.", this.splashWidth, "**")).append(System.lineSeparator());
        sb.append(StringTools.alignLeft("Institut fuer Verkehrssystemtechnik", this.splashWidth, "**")).append(System.lineSeparator());
        sb.append(StringTools.alignLeft("", this.splashWidth, "**")).append(System.lineSeparator());
        sb.append(StringTools.alignLeft("German Aerospace Center", this.splashWidth, "**")).append(System.lineSeparator());
        sb.append(StringTools.alignLeft("Institute of Transportation Systems", this.splashWidth, "**")).append(System.lineSeparator());
        sb.append(StringTools.alignLeft("http://www.dlr.de", this.splashWidth, "**")).append(System.lineSeparator());
        sb.append(this.STARS_LINE).append(System.lineSeparator());
    }

    public String getSplashScreen() {
        StringBuilder sb = new StringBuilder();
        sb.append(System.lineSeparator());
        sb.append(System.lineSeparator());
        if (this.showCopyright) {
            this.addCopyRight(sb);
        }
        sb.append(this.STARS_LINE).append(System.lineSeparator());
        sb.append(StringTools.centerText("", this.splashWidth, "**")).append(System.lineSeparator());
        ColorString program_name = new ColorString(this.programName, Color.GREEN, Effect.BOLD, Effect.UNDERLINE);
        sb.append(StringTools.centerText(program_name.toString(), this.splashWidth + program_name.getOverheadLength(), "**")).append(System.lineSeparator());
        sb.append(StringTools.centerText("", this.splashWidth, "**")).append(System.lineSeparator());
        if (!this.author.isEmpty()) {
            sb.append(this.getFormattedAuthor(this.author, Color.NONE)).append(System.lineSeparator());
        }
        sb.append(this.STARS_LINE).append(System.lineSeparator());
        if (this.options.size() > 0) {
            sb.append(this.STARS_LINE).append(System.lineSeparator());
            sb.append(this.getFormattedTitle("Runtime options", Color.CYAN)).append(System.lineSeparator());
            sb.append(StringTools.centerText("", this.splashWidth, "**")).append(System.lineSeparator());
            for (RuntimeOption ro : this.options) {
                sb.append(ro).append(System.lineSeparator());
            }
            sb.append(this.STARS_LINE).append(System.lineSeparator());
        }
        if (this.props.size() > 0) {
            sb.append(this.STARS_LINE).append(System.lineSeparator());
            sb.append(this.getFormattedTitle("Current configuration", Color.CYAN)).append(System.lineSeparator());
            sb.append(StringTools.centerText("", this.splashWidth, "**")).append(System.lineSeparator());
            for (Property s : this.props) {
                sb.append(s).append(System.lineSeparator());
            }
            sb.append(this.STARS_LINE).append(System.lineSeparator());
        }
        if (this.comments.size() > 0) {
            sb.append(this.STARS_LINE).append(System.lineSeparator());
            for (String string : this.comments) {
                sb.append(string).append(System.lineSeparator());
            }
            sb.append(this.STARS_LINE).append(System.lineSeparator());
        }
        sb.append(this.STARS_LINE).append(System.lineSeparator());
        sb.append(System.lineSeparator());
        return sb.toString();
    }

    private class RuntimeOption {
        String modificator;
        String variable = "";
        String defaultValue = "";

        private RuntimeOption() {
        }

        public String toString() {
            ColorString modif = new ColorString(this.modificator, Color.WHITE, Effect.BOLD);
            String var = "";
            String defa = "";
            int width = SplashScreen.this.splashWidth + modif.getOverheadLength();
            if (this.variable != null && !this.variable.isEmpty()) {
                var = " <" + this.variable.toUpperCase().replace(" ", "_") + "> ";
            }
            if (this.defaultValue != null && !this.defaultValue.isEmpty()) {
                defa = " : default " + this.defaultValue;
            }
            return StringTools.alignLeft(modif.toString() + var + defa, width, "**");
        }
    }

    private class Property {
        String name;
        String value;

        public Property(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String toString() {
            ColorString _name = new ColorString(this.name, Color.WHITE, Effect.BOLD, Effect.UNDERLINE);
            return StringTools.alignLeft(_name.toString() + ": " + this.value, SplashScreen.this.splashWidth + _name.getOverheadLength(), "**");
        }
    }
}

