/*
 * Decompiled with CFR 0.152.
 */
package de.dlr.ts.lisum.lisa;

import de.dlr.ts.commons.logger.DLRLogger;
import de.dlr.ts.commons.logger.ToString;
import de.dlr.ts.lisum.exceptions.LisaRESTfulServerNotFoundException;
import de.dlr.ts.lisum.lisa.PutMessageResponse;
import de.dlr.ts.lisum.lisa.Requests;
import de.dlr.ts.utils.xmladmin2.MalformedKeyOrNameException;
import de.dlr.ts.utils.xmladmin2.XMLAdmin2;
import de.dlr.ts.utils.xmladmin2.XMLNodeNotFoundException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolVersion;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClients;
import org.xml.sax.SAXException;

final class LisaCommands {
    private static int lisaServerPort;
    private static String lisaServerAddress;
    public static final String GET_TASK_URI = "/services/PDService/getTask";
    private static final String SET_DATA_DIR_URI = "/services/DDService/setDataDir";
    private static final String SET_TASK_LIST_URI = "/services/PDService/setTaskList";
    private static final String GET_TASK_LIST_URI = "/services/PDService/getTaskList";
    private static final String GET_OBJECT_LIST_URI = "/services/PDService/getObjectList";
    private static final String REMOVE_TASK_LIST_URI = "/services/PDService/removeTaskList";
    private static final String PUT_MESSAGE_CALLBACK_URI = "/services/PDCallback/putMessage";
    private static final HttpClient HTTP_CLIENT;

    LisaCommands(String lsa, int lsp) {
        lisaServerPort = lsp;
        lisaServerAddress = lsa;
    }

    public String toString() {
        ToString ts = new ToString("LisaCommands");
        return ts.add("lisaServerAddress", lisaServerAddress).add("lisaServerPort", lisaServerPort).toString();
    }

    private static String getURI() {
        return "http://" + lisaServerAddress + ":" + lisaServerPort;
    }

    public static boolean TestRESTfulServer() {
        try {
            HttpPost post = new HttpPost(LisaCommands.getURI() + GET_OBJECT_LIST_URI);
            String request = Requests.INSTANCE.getObjectListRequest(1, 1);
            StringEntity entity = new StringEntity(request, "UTF-8");
            post.setEntity((HttpEntity)entity);
            LisaCommands.execute(post);
        }
        catch (LisaRESTfulServerNotFoundException ex) {
            return false;
        }
        return true;
    }

    public void getTask(int id) throws LisaRESTfulServerNotFoundException {
        HttpPost post = new HttpPost(LisaCommands.getURI() + PUT_MESSAGE_CALLBACK_URI);
        String request = Requests.INSTANCE.getGetTaskRequest(id);
        StringEntity entity = new StringEntity(request, "UTF-8");
        post.setEntity((HttpEntity)entity);
        DLRLogger.finer((Object)this, request);
        Response response = LisaCommands.execute(post);
        DLRLogger.finer((Object)this, response.statusCode + " | " + response.body);
    }

    public PutMessageResponse putMessage(String message) throws LisaRESTfulServerNotFoundException {
        PutMessageResponse vektor = null;
        HttpPost post = new HttpPost(LisaCommands.getURI() + PUT_MESSAGE_CALLBACK_URI);
        String request = Requests.INSTANCE.getPutMessageRequest(message);
        StringEntity entity = new StringEntity(request, "UTF-8");
        post.setEntity((HttpEntity)entity);
        DLRLogger.finer((Object)this, "Sending requesto to Lisa: " + request);
        Response response = LisaCommands.execute(post);
        DLRLogger.finest((Object)this, "Lisa responds: " + response.statusCode + " | " + response.body);
        if (response.statusCode == 200) {
            vektor = new PutMessageResponse(response.body);
        }
        return vektor;
    }

    public int setTask(int zNr, int fNr, int interval) throws LisaRESTfulServerNotFoundException {
        int newTaskId = 0;
        try {
            HttpPost post = new HttpPost(LisaCommands.getURI() + SET_TASK_LIST_URI);
            String request = Requests.INSTANCE.getSetTaskRequest(zNr, fNr, interval);
            StringEntity entity = new StringEntity(request, "UTF-8");
            post.setEntity((HttpEntity)entity);
            Response response = LisaCommands.execute(post);
            DLRLogger.finer((Object)this, response.statusCode + " | " + response.body);
            XMLAdmin2 x = new XMLAdmin2().load(response.body.getBytes());
            newTaskId = x.getNode("ns2:ID").getValue(0);
        }
        catch (MalformedKeyOrNameException | XMLNodeNotFoundException | SAXException ex) {
            DLRLogger.severe((Object)this, ex);
        }
        return newTaskId;
    }

    public String getObjectList() throws LisaRESTfulServerNotFoundException {
        HttpPost post = new HttpPost(LisaCommands.getURI() + GET_OBJECT_LIST_URI);
        String request = Requests.INSTANCE.getObjectListRequest(1, 1);
        StringEntity entity = new StringEntity(request, "UTF-8");
        post.setEntity((HttpEntity)entity);
        Response response = LisaCommands.execute(post);
        DLRLogger.finer((Object)this, response.statusCode + " | " + response.body);
        return response.body;
    }

    public void removeTaskList(int id) throws LisaRESTfulServerNotFoundException {
        HttpPost post = new HttpPost(LisaCommands.getURI() + REMOVE_TASK_LIST_URI);
        String request = Requests.INSTANCE.getRemoveTaskListRequest(id);
        StringEntity entity = new StringEntity(request, "UTF-8");
        post.setEntity((HttpEntity)entity);
        Response execute = LisaCommands.execute(post);
        DLRLogger.finer((Object)this, execute.statusCode + " | " + execute.body);
    }

    public int[] getTaskList(int zNr, int fNr) throws LisaRESTfulServerNotFoundException {
        int[] ids = null;
        try {
            String uri = GET_TASK_LIST_URI;
            HttpPost post = new HttpPost(LisaCommands.getURI() + uri);
            String request = Requests.INSTANCE.getTaskListRequest(zNr, fNr);
            StringEntity entity = new StringEntity(request, "UTF-8");
            post.setEntity((HttpEntity)entity);
            Response execute = LisaCommands.execute(post);
            DLRLogger.finer((Object)this, execute.statusCode + " | " + execute.body);
            XMLAdmin2 x = new XMLAdmin2().load(execute.body.getBytes());
            int nodesCount = x.getNodesCount("ns2:TaskInfo");
            ids = new int[nodesCount];
            for (int i = 0; i < nodesCount; ++i) {
                int id;
                ids[i] = id = x.getNode("ns2:TaskInfo", i).getNode("ns2:ID").getValue(-1);
            }
        }
        catch (MalformedKeyOrNameException | XMLNodeNotFoundException | SAXException ex) {
            DLRLogger.severe((Object)this, ex);
        }
        return ids;
    }

    public void setDataDir(File dataDir) throws LisaRESTfulServerNotFoundException {
        HttpPost post = new HttpPost(LisaCommands.getURI() + SET_DATA_DIR_URI);
        String request = Requests.INSTANCE.getSetDataDirRequest(dataDir.getAbsolutePath());
        StringEntity entity = new StringEntity(request, "UTF-8");
        post.setEntity((HttpEntity)entity);
        Response execute = LisaCommands.execute(post);
        if (execute.statusCode == 200) {
            DLRLogger.config((Object)this, "Lisa DataDir set successfully.");
        }
    }

    static Response execute(HttpPost post) throws LisaRESTfulServerNotFoundException {
        try {
            HttpResponse execute = HTTP_CLIENT.execute((HttpUriRequest)post);
            String reasonPhrase = execute.getStatusLine().getReasonPhrase();
            int statusCode = execute.getStatusLine().getStatusCode();
            ProtocolVersion protocolVersion = execute.getStatusLine().getProtocolVersion();
            ByteArrayOutputStream outstream = new ByteArrayOutputStream();
            execute.getEntity().writeTo((OutputStream)outstream);
            byte[] responseBody = outstream.toByteArray();
            Response response = new Response();
            response.statusCode = statusCode;
            response.body = new String(responseBody);
            return response;
        }
        catch (IOException ex) {
            throw new LisaRESTfulServerNotFoundException("");
        }
    }

    static {
        HTTP_CLIENT = HttpClients.createDefault();
    }

    private static class Response {
        int statusCode;
        String body;

        private Response() {
        }
    }
}

