/*
 * Decompiled with CFR 0.152.
 */
package de.dlr.ts.lisum.lisa;

import de.dlr.ts.commons.logger.DLRLogger;
import de.dlr.ts.utils.xmladmin2.MalformedKeyOrNameException;
import de.dlr.ts.utils.xmladmin2.XMLAdmin2;
import de.dlr.ts.utils.xmladmin2.XMLNode;
import de.dlr.ts.utils.xmladmin2.XMLNodeNotFoundException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.xml.sax.SAXException;

class LisaConfigurationFiles
implements Iterable<ControlUnit> {
    public List<ControlUnit> controlUnits = new ArrayList<ControlUnit>();
    public File lisaFolder;

    LisaConfigurationFiles() {
    }

    @Override
    public Iterator<ControlUnit> iterator() {
        return this.controlUnits.iterator();
    }

    public void load(File lisaFolder) {
        this.lisaFolder = lisaFolder;
        String fullpath = lisaFolder.getAbsolutePath() + File.separator;
        for (String name : lisaFolder.list()) {
            if (!name.endsWith(".xml")) continue;
            try {
                File controlUnitConfigFile = new File(fullpath + name);
                XMLAdmin2 x = new XMLAdmin2().load(controlUnitConfigFile);
                XMLNode ocit = x.getNode("Kopfdaten.Identifikation.OCITKennung");
                int zNr = ocit.getNode("ZNr").getValue(0);
                int fNr = ocit.getNode("FNr").getValue(0);
                String _name = "z" + zNr + "_fg" + fNr;
                DLRLogger.config((Object)this, "Creating Control Unit " + _name);
                ControlUnit controlUnit = new ControlUnit();
                this.controlUnits.add(controlUnit);
                controlUnit.zNr = zNr;
                controlUnit.fNr = fNr;
                controlUnit.fullName = _name;
                this.extractSignalGroups(x, controlUnit);
                this.extractDetectors(x, controlUnit);
                this.extractSignalPrograms(x, controlUnit);
            }
            catch (MalformedKeyOrNameException | XMLNodeNotFoundException | IOException | SAXException ex) {
                ex.printStackTrace(System.err);
            }
        }
        DLRLogger.config((Object)this, "Lisa Configuration files read successfully");
        DLRLogger.config((Object)this, "ControlUnits count: " + this.controlUnits.size());
    }

    public File getLisaDirectory() {
        return this.lisaFolder;
    }

    private void extractSignalGroups(XMLAdmin2 x, ControlUnit controlUnit) {
        try {
            int gruppenCount = x.getNodesCount("SignalgruppeListe.Signalgruppe");
            for (int i = 0; i < gruppenCount; ++i) {
                XMLNode node = x.getNode("SignalgruppeListe.Signalgruppe", i);
                String bezeichnung = node.getNode("Bezeichnung").getValue();
                int index = node.getNode("ObjNr").getValue(0);
                DLRLogger.info((Object)this, "Adding signal group: " + bezeichnung);
                ControlUnit.SignalGroup sg = new ControlUnit.SignalGroup();
                controlUnit.signalGroups.add(sg);
                sg.bezeichnung = bezeichnung;
                sg.index = index;
            }
        }
        catch (MalformedKeyOrNameException | XMLNodeNotFoundException ex) {
            ex.printStackTrace(System.err);
        }
    }

    void extractDetectors(XMLAdmin2 x, ControlUnit controlUnit) throws XMLNodeNotFoundException, MalformedKeyOrNameException, SAXException, IOException {
        if (!x.hasNode("DigEingangListe")) {
            return;
        }
        int detectorsCount = x.getNodesCount("DigEingangListe.DigEingang");
        for (int i = 0; i < detectorsCount; ++i) {
            XMLNode node = x.getNode("DigEingangListe.DigEingang", i);
            String bezeichnung = node.getNode("Bezeichnung").getValue();
            int nr = node.getNode("ObjNr").getValue(0);
            String fullName = controlUnit.fullName + "." + bezeichnung;
            ControlUnit.Detector detector = new ControlUnit.Detector();
            detector.objNr = nr;
            detector.bezeichnung = bezeichnung;
            detector.fullName = fullName;
            controlUnit.detectors.add(detector);
            DLRLogger.info((Object)this, "Adding detector: " + fullName + " (" + nr + ")");
        }
    }

    void extractSignalPrograms(XMLAdmin2 x, ControlUnit controlUnit) throws XMLNodeNotFoundException, MalformedKeyOrNameException, SAXException, IOException {
        if (!x.hasNode("SignalprogrammListe")) {
            return;
        }
        int signalProgramsCount = x.getNodesCount("SignalprogrammListe.Signalprogramm");
        for (int i = 0; i < signalProgramsCount; ++i) {
            XMLNode node = x.getNode("SignalprogrammListe.Signalprogramm", i);
            String bezeichnung = node.getNode("Bezeichnung").getValue();
            int objnr = node.getNode("ObjNr").getValue(0);
            ControlUnit.SignalProgram sp = new ControlUnit.SignalProgram();
            sp.bezeichnung = bezeichnung;
            sp.objNr = objnr;
            controlUnit.signalPrograms.add(sp);
        }
    }

    public static class ControlUnit {
        int zNr;
        int fNr;
        String fullName;
        public List<SignalGroup> signalGroups = new ArrayList<SignalGroup>();
        public List<Detector> detectors = new ArrayList<Detector>();
        public List<SignalProgram> signalPrograms = new ArrayList<SignalProgram>();

        public static class SignalProgram {
            String bezeichnung;
            int objNr;
        }

        public static class Detector {
            String bezeichnung;
            int objNr;
            String fullName;
        }

        public static class SignalGroup {
            String bezeichnung;
            int index;
        }
    }
}

