/*
 * Decompiled with CFR 0.152.
 */
package de.dlr.ts.lisum.lisa;

import de.dlr.ts.commons.logger.DLRLogger;
import de.dlr.ts.lisum.enums.LightColor;
import de.dlr.ts.lisum.exceptions.LisaRESTfulServerNotFoundException;
import de.dlr.ts.lisum.interfaces.ControlUnitInterface;
import de.dlr.ts.lisum.interfaces.DetectorInterface;
import de.dlr.ts.lisum.interfaces.SignalProgramInterface;
import de.dlr.ts.lisum.lisa.LisaCommands;
import de.dlr.ts.lisum.lisa.LisaConfigurationFiles;
import de.dlr.ts.lisum.lisa.LisaDetectors;
import de.dlr.ts.lisum.lisa.LisaSignalGroups;
import de.dlr.ts.lisum.lisa.LisaSignalPrograms;
import de.dlr.ts.lisum.lisa.Message;
import de.dlr.ts.lisum.lisa.Persistence;
import de.dlr.ts.lisum.lisa.PutMessageResponse;
import de.dlr.ts.lisum.lisa.WunschVector;
import java.io.File;

final class LisaControlUnit
implements ControlUnitInterface {
    private int zNr;
    private int fNr;
    private String fullName;
    private final LisaSignalGroups lisaSignalGroups = new LisaSignalGroups();
    private final LisaDetectors lisaDetectors = new LisaDetectors();
    private final LisaSignalPrograms signalPrograms = new LisaSignalPrograms();
    private Message message;
    private final WunschVector vector = new WunschVector(this.signalPrograms);
    private int currentTask;
    private LisaCommands commands;
    private Persistence persistence;
    private boolean enabled = false;

    public void setCommands(LisaCommands commands) {
        this.commands = commands;
    }

    public void setLisaDirectory(File lisaDirectory) {
        this.persistence = new Persistence(this.vector, lisaDirectory, this);
    }

    void load(LisaConfigurationFiles.ControlUnit cu) {
        DLRLogger.config((Object)this, "Loading Control Unit " + cu.fullName);
        this.zNr = cu.zNr;
        this.fNr = cu.fNr;
        this.fullName = cu.fullName;
        this.lisaSignalGroups.load(cu);
        this.lisaDetectors.load(cu);
        this.signalPrograms.load(cu);
    }

    @Override
    public DetectorInterface getDetector(String name) {
        return this.lisaDetectors.getDetector(name);
    }

    private String getObjectList() throws LisaRESTfulServerNotFoundException {
        return this.commands.getObjectList();
    }

    public void initBeforePlay() throws LisaRESTfulServerNotFoundException {
        this.persistence.readPersistence();
        String objectList = this.getObjectList();
        this.removeAllOldTaskLists();
        this.currentTask = this.commands.setTask(this.zNr, this.fNr, 60);
        this.message = new Message(this.currentTask);
        this.message.intervall = 60;
        String command = this.message.getCommand(Message.Type.Init, this.vector, null, 0L);
        this.commands.putMessage(command);
    }

    public void executeSimulationStep(long simulationTime) throws LisaRESTfulServerNotFoundException {
        if (this.enabled) {
            String detectorsString = this.lisaDetectors.getLisaString();
            String commandToLisa = this.message.getCommand(Message.Type.Run, this.vector, detectorsString, simulationTime);
            PutMessageResponse messageResponseFromLisa = this.commands.putMessage(commandToLisa);
            this.lisaSignalGroups.parseStates(messageResponseFromLisa.getSignalsStateVector());
        }
    }

    private void removeAllOldTaskLists() throws LisaRESTfulServerNotFoundException {
        int[] taskList;
        for (int i : taskList = this.commands.getTaskList(this.zNr, this.fNr)) {
            this.commands.removeTaskList(i);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Control Unit: ZNr ").append(this.zNr).append(" FNr ").append(this.fNr).append(" ");
        sb.append(this.lisaSignalGroups.toString());
        return sb.toString();
    }

    public LisaSignalGroups getLisaSignalGroups() {
        return this.lisaSignalGroups;
    }

    @Override
    public final String getFullName() {
        return this.fullName;
    }

    @Override
    public int signalGroupsCount() {
        return this.lisaSignalGroups.signalsCount();
    }

    @Override
    public SignalProgramInterface[] getSignalPrograms() {
        return this.signalPrograms.getSignalProgramsArray();
    }

    @Override
    public void setCurrentSignalProgram(int index) {
        this.signalPrograms.setCurrentSignalProgram(index);
        if (index == 0) {
            this.vector.setKnotenEinAus(2);
        } else {
            this.vector.setKnotenEinAus(1);
        }
    }

    @Override
    public boolean isVA() {
        return this.vector.isVA();
    }

    @Override
    public void setVA(boolean va) {
        this.vector.setVA(va);
    }

    @Override
    public boolean isIV() {
        return this.vector.isIV();
    }

    @Override
    public void setIV(boolean iv) {
        this.vector.setIV(iv);
    }

    @Override
    public boolean isOV() {
        return this.vector.isOV();
    }

    @Override
    public void setOV(boolean ov) {
        this.vector.setOV(ov);
    }

    @Override
    public SignalProgramInterface getCurrentSignalProgram() {
        return this.signalPrograms.getCurrentSignalProgram();
    }

    @Override
    public int getEbene() {
        return this.vector.getEbene();
    }

    @Override
    public void setEbene(int ebene) {
        this.vector.setEbene(ebene);
    }

    @Override
    public int getKnotenEinAus() {
        return this.vector.getKnotenEinAus();
    }

    @Override
    public void setKnotenEinAus(int einAus) {
        this.vector.setKnotenEinAus(einAus);
    }

    @Override
    public void storePersistent() {
        this.persistence.store();
    }

    @Override
    public LightColor getLightColor(int signalGroupIndex) {
        return this.lisaSignalGroups.getColor(signalGroupIndex);
    }

    @Override
    public LightColor getLightColor(String signalGroupName) {
        return this.lisaSignalGroups.getColor(signalGroupName);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setCoordinated(int coordinated) {
        this.vector.setCoordinated(coordinated);
    }

    @Override
    public int getCoordinated() {
        return this.vector.getCoordinated();
    }
}

