/*
 * Decompiled with CFR 0.152.
 */
package de.dlr.ts.lisum.lisa;

import de.dlr.ts.commons.logger.DLRLogger;
import de.dlr.ts.lisum.exceptions.LisaRESTfulServerNotFoundException;
import de.dlr.ts.lisum.interfaces.ControlUnitInterface;
import de.dlr.ts.lisum.lisa.LisaCommands;
import de.dlr.ts.lisum.lisa.LisaConfigurationFiles;
import de.dlr.ts.lisum.lisa.LisaControlUnit;
import java.util.ArrayList;
import java.util.List;

public class LisaControlUnits {
    private final List<LisaControlUnit> controlUnits = new ArrayList<LisaControlUnit>();

    void load(LisaConfigurationFiles configurationFiles, LisaCommands lisaCommands) {
        for (LisaConfigurationFiles.ControlUnit cu : configurationFiles) {
            DLRLogger.config((Object)this, "Creating Control Unit " + cu.fullName);
            LisaControlUnit lisaControlUnit = new LisaControlUnit();
            lisaControlUnit.setCommands(lisaCommands);
            lisaControlUnit.setLisaDirectory(configurationFiles.getLisaDirectory());
            lisaControlUnit.load(cu);
            this.controlUnits.add(lisaControlUnit);
        }
    }

    public int getControlUnitsCount() {
        return this.controlUnits.size();
    }

    void addControlUnit(LisaControlUnit controlUnit) {
        this.controlUnits.add(controlUnit);
    }

    public ControlUnitInterface[] getControlUnits() {
        ControlUnitInterface[] array = new ControlUnitInterface[this.controlUnits.size()];
        return this.controlUnits.toArray(array);
    }

    public ControlUnitInterface getControlUnit(String name) {
        for (LisaControlUnit controlUnit : this.controlUnits) {
            if (!controlUnit.getFullName().equals(name)) continue;
            return controlUnit;
        }
        return null;
    }

    public void executeSimulationStep(long simulationTime) throws LisaRESTfulServerNotFoundException {
        for (LisaControlUnit sgt : this.controlUnits) {
            DLRLogger.finer((Object)this, "Executing on " + sgt);
            sgt.executeSimulationStep(simulationTime);
        }
    }

    public void initBeforePlay() throws LisaRESTfulServerNotFoundException {
        for (LisaControlUnit lisaControlUnit : this.controlUnits) {
            lisaControlUnit.initBeforePlay();
        }
    }
}

