/*
 * Decompiled with CFR 0.152.
 */
package de.dlr.ts.lisum.lisa;

import de.dlr.ts.commons.logger.DLRLogger;
import de.dlr.ts.commons.logger.ToString;
import de.dlr.ts.lisum.interfaces.DetectorInterface;
import java.util.ArrayList;
import java.util.List;

class LisaDetector
implements DetectorInterface,
Comparable<LisaDetector> {
    private final int index;
    private final String id;
    private String lastVehicleId = null;
    private final List<Integer> flanken = new ArrayList<Integer>();

    public String toString() {
        ToString tos = new ToString("Detektoren");
        tos.add("index", this.index);
        tos.add("name", this.id);
        tos.add("FlankenCount", this.flanken.size());
        return tos.toString();
    }

    public LisaDetector(int index, String id) {
        this.index = index;
        this.id = id;
    }

    @Override
    public void addFlanke(int slope) {
        DLRLogger.finer((Object)this, this.id + ": adding detector slope " + slope);
        this.flanken.add(slope);
    }

    void clear() {
        this.flanken.clear();
    }

    boolean isEmpty() {
        return this.flanken.isEmpty();
    }

    String getLisaString(boolean withIndex) {
        StringBuilder sb = new StringBuilder();
        if (withIndex) {
            sb.append("(").append(this.index - 1).append(")");
        }
        DLRLogger.finest((Object)this, "Lisa String for detector " + this);
        if (this.flanken.size() > 0) {
            Integer value = this.flanken.get(0);
            DLRLogger.finest((Object)this, "Flanke value: " + value);
            sb.append(value);
            if (this.flanken.size() == 2) {
                sb.append("!").append(this.flanken.get(1));
            }
        }
        this.flanken.clear();
        return sb.toString();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public int compareTo(LisaDetector t) {
        if (t.index > this.index) {
            return -1;
        }
        if (t.index == this.index) {
            return 0;
        }
        return 1;
    }

    @Deprecated
    public void setFromSumo(String[] vehicles) {
        this.flanken.clear();
        if (vehicles == null) {
            if (this.lastVehicleId != null) {
                this.flanken.add(-10);
            }
            this.lastVehicleId = null;
        } else if (vehicles.length == 1) {
            if (this.lastVehicleId == null) {
                this.flanken.add(50);
            } else if (!this.lastVehicleId.equals(vehicles[0])) {
                this.flanken.add(-30);
                this.flanken.add(60);
            }
            this.lastVehicleId = vehicles[0];
        }
    }
}

