/*
 * Decompiled with CFR 0.152.
 */
package de.dlr.ts.lisum.lisa;

import de.dlr.ts.commons.logger.DLRLogger;
import de.dlr.ts.lisum.interfaces.DetectorInterface;
import de.dlr.ts.lisum.lisa.LisaConfigurationFiles;
import de.dlr.ts.lisum.lisa.LisaDetector;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

class LisaDetectors {
    private final List<LisaDetector> detectors = new ArrayList<LisaDetector>();

    public void sort() {
        Collections.sort(this.detectors);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Detectors").append("\n");
        for (LisaDetector det : this.detectors) {
            sb.append(det).append("\n");
        }
        return sb.toString();
    }

    void load(LisaConfigurationFiles.ControlUnit cu) {
        for (LisaConfigurationFiles.ControlUnit.Detector de : cu.detectors) {
            DLRLogger.info((Object)this, "Adding detector: " + de.fullName + " (" + de.objNr + ")");
            LisaDetector lisaDetector = new LisaDetector(de.objNr, de.bezeichnung);
            this.detectors.add(lisaDetector);
        }
    }

    public DetectorInterface getDetector(String detectorId) {
        for (LisaDetector detector : this.detectors) {
            if (!detector.getId().equals(detectorId)) continue;
            return detector;
        }
        return null;
    }

    public void clear() {
        for (LisaDetector detector : this.detectors) {
            detector.clear();
        }
    }

    public String getLisaString() {
        StringBuilder sb = new StringBuilder();
        boolean addIndex = false;
        for (int i = 0; i < this.detectors.size(); ++i) {
            LisaDetector detector = this.detectors.get(i);
            if (detector.isEmpty()) {
                addIndex = true;
                continue;
            }
            sb.append(detector.getLisaString(addIndex)).append("/");
            addIndex = false;
        }
        String ts = sb.toString();
        if (ts.isEmpty()) {
            return "";
        }
        return ts.substring(0, ts.length() - 1);
    }

    public int detectorsCount() {
        return this.detectors.size();
    }
}

