/*
 * Decompiled with CFR 0.152.
 */
package de.dlr.ts.lisum.lisa;

import de.dlr.ts.lisum.lisa.Lisa;
import de.dlr.ts.lisum.lisa.LisaSignalPrograms;
import org.apache.maven.artifact.versioning.ComparableVersion;

class WunschVector {
    private int ebene = 4;
    private int betriebsArt = 1;
    private int knotenEinAus = 0;
    private int vaEinAus = 0;
    private int ivEinAus = 0;
    private int oepnvEinAus = 0;
    private int coordinated = 0;
    private final LisaSignalPrograms signalPrograms;
    private static final ComparableVersion version72 = new ComparableVersion("7.2");

    public String getVector() {
        int signalProg = 0;
        if (this.signalPrograms.getCurrentSignalProgram() != null) {
            signalProg = this.signalPrograms.getCurrentSignalProgram().getObjNr();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.ebene).append(";");
        if (Lisa.minVersion(version72)) {
            sb.append("0;0;0;");
        }
        sb.append(this.betriebsArt).append(";");
        sb.append(signalProg).append(";");
        sb.append(this.knotenEinAus).append(";");
        sb.append(this.vaEinAus).append(";");
        sb.append(this.ivEinAus).append(";");
        sb.append(this.oepnvEinAus).append(";");
        sb.append(this.coordinated);
        return sb.toString();
    }

    public WunschVector(LisaSignalPrograms signalPrograms) {
        this.signalPrograms = signalPrograms;
    }

    public boolean isVA() {
        return this.vaEinAus == 2;
    }

    public void setVA(boolean va) {
        this.vaEinAus = va ? 2 : 1;
    }

    public boolean isIV() {
        return this.ivEinAus == 2;
    }

    public void setIV(boolean iv) {
        this.ivEinAus = iv ? 2 : 1;
    }

    public boolean isOV() {
        return this.oepnvEinAus == 2;
    }

    public void setOV(boolean ov) {
        this.oepnvEinAus = ov ? 2 : 1;
    }

    public void setEbene(int ebene) {
        this.ebene = ebene;
    }

    public int getEbene() {
        return this.ebene;
    }

    public void setKnotenEinAus(int onOff) {
        this.knotenEinAus = onOff;
    }

    public int getKnotenEinAus() {
        return this.knotenEinAus;
    }

    public int getBetriebsArt() {
        return this.betriebsArt;
    }

    public void setBetriebsArt(int betriebsArt) {
        this.betriebsArt = betriebsArt;
    }

    public String getSignalProgram() {
        return this.signalPrograms.getCurrentSignalProgram().getName();
    }

    public int getSignalProgramIndex() {
        return this.signalPrograms.getCurrentSignalProgramIndex();
    }

    public int getCoordinated() {
        return this.coordinated;
    }

    public void setCoordinated(int coordinated) {
        this.coordinated = coordinated;
    }
}

