/*
 * Decompiled with CFR 0.152.
 */
package de.dlr.ts.lisum.simulation;

import de.dlr.ts.commons.logger.DLRLogger;
import de.dlr.ts.commons.logger.ToString;
import de.dlr.ts.utils.xmladmin2.Attributes;
import de.dlr.ts.utils.xmladmin2.MalformedKeyOrNameException;
import de.dlr.ts.utils.xmladmin2.XMLAdmin2;
import de.dlr.ts.utils.xmladmin2.XMLNode;
import de.dlr.ts.utils.xmladmin2.XMLNodeNotFoundException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.xml.sax.SAXException;

public class ConfigurationFile
implements Iterable<CFControlUnit> {
    private final List<CFControlUnit> controlUnits = new ArrayList<CFControlUnit>();
    private File configurationFile;
    private String lisaDirectoryName;
    private File lisaDirectory;

    @Override
    public Iterator<CFControlUnit> iterator() {
        return this.controlUnits.iterator();
    }

    public File getConfigurationFile() {
        return this.configurationFile;
    }

    public File getLisaDirectory() {
        return this.lisaDirectory;
    }

    public void read(File configurationFile) {
        this.configurationFile = configurationFile.getAbsoluteFile();
        try {
            XMLAdmin2 x = new XMLAdmin2().load(configurationFile);
            try {
                DLRLogger.info((Object)this, "Reading configuration file: " + configurationFile);
                this.lisaDirectoryName = x.getNode("input.lisa").getValue();
                this.lisaDirectory = new File(this.lisaDirectoryName);
                if (!this.lisaDirectory.isAbsolute()) {
                    this.lisaDirectory = new File(this.configurationFile.getParentFile() + File.separator + this.lisaDirectoryName);
                }
                int count = x.getNodesCount("controlUnits.controlUnit");
                for (int i = 0; i < count; ++i) {
                    XMLNode controlUnitNode = x.getNode("controlUnits.controlUnit", i);
                    Attributes atts = x.getNode("controlUnits.controlUnit", i).getAttributes();
                    String _lisa = atts.get("lisa").getValue();
                    String _sumo = atts.get("sumo").getValue();
                    CFControlUnit controlUnit = new CFControlUnit(_lisa, _sumo);
                    this.controlUnits.add(controlUnit);
                    DLRLogger.info((Object)this, "Reading ControlUnit " + _lisa + " is " + _sumo);
                    if (controlUnitNode.hasNode("signalGroups")) {
                        this.extractSignalGroups(controlUnit, controlUnitNode);
                    }
                    if (!controlUnitNode.hasNode("detectors")) continue;
                    this.extractDetectors(controlUnit, controlUnitNode);
                }
            }
            catch (XMLNodeNotFoundException ex) {
                DLRLogger.severe((Object)this, ex);
            }
        }
        catch (MalformedKeyOrNameException | IOException | SAXException ex) {
            DLRLogger.severe((Object)this, ex);
        }
    }

    private void extractSignalGroups(CFControlUnit controlUnit, XMLNode node) throws MalformedKeyOrNameException, XMLNodeNotFoundException {
        int count = node.getNodesCount("signalGroups.signalGroup");
        for (int j = 0; j < count; ++j) {
            XMLNode signalGroupNode = node.getNode("signalGroups.signalGroup", j);
            String lisa = signalGroupNode.getAttributes().get("lisa").getValue();
            String sumo = signalGroupNode.getAttributes().get("sumo").getValue();
            String ifOff = null;
            if (signalGroupNode.getAttributes().hasAttribute("main")) {
                ifOff = signalGroupNode.getAttributes().get("main").getValue();
            }
            CFControlUnit.SignalGroup sg = new CFControlUnit.SignalGroup(lisa, sumo, ifOff);
            controlUnit.signalGroups.add(sg);
            DLRLogger.config((Object)this, "Reading " + sg);
        }
    }

    private void extractDetectors(CFControlUnit controlUnit, XMLNode node) throws MalformedKeyOrNameException, XMLNodeNotFoundException {
        int count = node.getNodesCount("detectors.detector");
        for (int i = 0; i < count; ++i) {
            XMLNode _node = node.getNode("detectors.detector", i);
            String lisa = _node.getAttributes().get("lisa").getValue();
            String sumo = _node.getAttributes().get("sumo").getValue();
            CFControlUnit.Detector det = new CFControlUnit.Detector(lisa, sumo);
            controlUnit.detectors.add(det);
            DLRLogger.config((Object)this, "Reading " + det);
        }
    }

    public static class CFControlUnit {
        public String lisaName;
        public String sumoName;
        public List<SignalGroup> signalGroups = new ArrayList<SignalGroup>();
        public List<Detector> detectors = new ArrayList<Detector>();

        public CFControlUnit(String lisaName, String sumoName) {
            this.lisaName = lisaName;
            this.sumoName = sumoName;
        }

        public static class Detector {
            public String lisaName;
            public String sumoName;

            public Detector(String lisa, String sumo) {
                this.lisaName = lisa;
                this.sumoName = sumo;
            }

            public String toString() {
                return new ToString("Detector").add("Lisa", this.lisaName).add("Sumo", this.sumoName).toString();
            }
        }

        public static class SignalGroup {
            public String lisa;
            public String sumo;
            public String ifOff;

            public SignalGroup(String lisa, String sumo, String ifOff) {
                this.lisa = lisa;
                this.sumo = sumo;
                this.ifOff = ifOff;
            }

            public String toString() {
                return new ToString("SignalGroup").add("Lisa", this.lisa).add("Sumo", this.sumo).add("IfOff", this.ifOff).toString();
            }
        }
    }
}

