/*
 * Decompiled with CFR 0.152.
 */
package de.dlr.ts.lisum.simulation;

import de.dlr.ts.commons.logger.DLRLogger;
import de.dlr.ts.lisum.exceptions.LisumException;
import de.dlr.ts.lisum.interfaces.CityInterface;
import de.dlr.ts.lisum.interfaces.SimulationListener;
import de.dlr.ts.lisum.lisa.Lisa;
import de.dlr.ts.lisum.simulation.ConfigurationFile;
import de.dlr.ts.lisum.simulation.SimulationControlUnits;
import de.dlr.ts.lisum.simulation.SimulationDetectors;
import de.dlr.ts.lisum.simulation.SimulationFiles;
import de.dlr.ts.lisum.sumo.Sumo;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class LisumSimulation
implements SimulationListener {
    private Sumo sumo;
    private CityInterface cityInterface;
    private SimulationDetectors detectors;
    private SimulationControlUnits controlUnits;
    private SimulationFiles simulationFiles;
    private final List<SimulationStepListener> listeners = new ArrayList<SimulationStepListener>();
    private long currentSimulationStep = 0L;
    private ConfigurationFile configurationFile = new ConfigurationFile();
    private final String sumoExec;
    private String sumoConfig;
    private final int sumoPort;
    private final String lisaServerAddress;
    private final int lisaServerPort;

    public LisumSimulation(String sumoExec, int sumoPort, String lisaServerAddress, int lisaServerPort) {
        this.sumoExec = sumoExec;
        this.sumoPort = sumoPort;
        this.lisaServerAddress = lisaServerAddress;
        this.lisaServerPort = lisaServerPort;
    }

    public void setSumoConfig(String sumoConfig) {
        this.sumoConfig = sumoConfig;
    }

    public long getCurrentSimulationStep() {
        return this.currentSimulationStep;
    }

    public ConfigurationFile getConfigurationFile() {
        return this.configurationFile;
    }

    public void load(File lisumConfigurationFile) throws LisumException, Exception {
        this.configurationFile = new ConfigurationFile();
        this.configurationFile.read(lisumConfigurationFile);
        this.simulationFiles = new SimulationFiles();
        this.simulationFiles.read(lisumConfigurationFile, this.sumoConfig);
        this.simulationFiles.setLisaDataDirectory(this.configurationFile.getLisaDirectory());
        if (this.sumoConfig == null) {
            this.sumoConfig = this.simulationFiles.getSumoConfigFile().getCanonicalPath();
        }
        this.load();
    }

    public void addListener(SimulationStepListener listener) {
        this.listeners.add(listener);
    }

    public CityInterface getCityInterface() {
        return this.cityInterface;
    }

    public SimulationDetectors getDetectors() {
        return this.detectors;
    }

    public Sumo getSumo() {
        return this.sumo;
    }

    public void load() throws Exception {
        this.sumo = new Sumo(this, this.sumoExec, this.sumoConfig, this.sumoPort);
        this.sumo.initBeforePlay();
        this.cityInterface = Lisa.create(this.lisaServerAddress, this.lisaServerPort);
        this.cityInterface.load(this.simulationFiles.getLisaDataDirectory());
        this.controlUnits = new SimulationControlUnits();
        this.controlUnits.load(this.configurationFile, this.cityInterface);
        this.detectors = new SimulationDetectors();
        this.detectors.load(this.configurationFile, this.cityInterface);
    }

    public InitBeforePlayResponse initBeforePlay() {
        InitBeforePlayResponse initBeforePlay = this.cityInterface.initBeforePlay();
        if (initBeforePlay != InitBeforePlayResponse.OK) {
            return initBeforePlay;
        }
        this.currentSimulationStep = 0L;
        this.sumo.initBeforePlay();
        DLRLogger.info("Project loaded successfully.");
        return InitBeforePlayResponse.OK;
    }

    public Runnable getRunnable() {
        return this.sumo.getRunnable();
    }

    public SimulationFiles getSimulationFiles() {
        return this.simulationFiles;
    }

    public SimulationControlUnits getControlUnits() {
        return this.controlUnits;
    }

    @Override
    public void executeSimulationStep(long simulationStep) {
        this.currentSimulationStep = simulationStep;
        this.cityInterface.executeSimulationStep(simulationStep);
        for (SimulationStepListener listener : this.listeners) {
            listener.step(simulationStep);
        }
    }

    public static enum InitBeforePlayResponse {
        OK,
        LisaRESTfulServerNotFound;

    }

    public static interface SimulationStepListener {
        public void step(long var1);
    }
}

