/*
 * Decompiled with CFR 0.152.
 */
package de.dlr.ts.lisum.simulation;

import de.dlr.ts.commons.logger.DLRLogger;
import de.dlr.ts.lisum.interfaces.CityInterface;
import de.dlr.ts.lisum.interfaces.ControlUnitInterface;
import de.dlr.ts.lisum.interfaces.DetectorInterface;
import de.dlr.ts.lisum.simulation.ConfigurationFile;
import java.util.HashMap;
import java.util.Map;

public class SimulationDetectors {
    private final Map<String, DetectorInterface> detectors = new HashMap<String, DetectorInterface>();

    public void load(ConfigurationFile configFile, CityInterface city) {
        DLRLogger.info((Object)this, "Loading detectors");
        for (ConfigurationFile.CFControlUnit controlUnit : configFile) {
            ControlUnitInterface controlUnitInt = city.getControlUnit(controlUnit.lisaName);
            for (int i = 0; i < controlUnit.detectors.size(); ++i) {
                ConfigurationFile.CFControlUnit.Detector det = controlUnit.detectors.get(i);
                DetectorInterface detectorInt = controlUnitInt.getDetector(det.lisaName);
                if (detectorInt == null) continue;
                this.detectors.put(det.sumoName, detectorInt);
            }
        }
    }

    public DetectorInterface getDetectorPerSumoId(String id) {
        return this.detectors.get(id);
    }
}

