/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sumo.libtraci;

import org.eclipse.sumo.libtraci.ContextSubscriptionResults;
import org.eclipse.sumo.libtraci.IntVector;
import org.eclipse.sumo.libtraci.StringStringPair;
import org.eclipse.sumo.libtraci.StringVector;
import org.eclipse.sumo.libtraci.SubscriptionResults;
import org.eclipse.sumo.libtraci.TraCIResults;
import org.eclipse.sumo.libtraci.libtraciJNI;

public class ChargingStation {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected ChargingStation(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(ChargingStation obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    protected static long swigRelease(ChargingStation obj) {
        long ptr = 0L;
        if (obj != null) {
            if (!obj.swigCMemOwn) {
                throw new RuntimeException("Cannot release ownership as memory is not owned");
            }
            ptr = obj.swigCPtr;
            obj.swigCMemOwn = false;
            obj.delete();
        }
        return ptr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                libtraciJNI.delete_ChargingStation(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public static String getLaneID(String stopID) {
        return libtraciJNI.ChargingStation_getLaneID(stopID);
    }

    public static double getStartPos(String stopID) {
        return libtraciJNI.ChargingStation_getStartPos(stopID);
    }

    public static double getEndPos(String stopID) {
        return libtraciJNI.ChargingStation_getEndPos(stopID);
    }

    public static String getName(String stopID) {
        return libtraciJNI.ChargingStation_getName(stopID);
    }

    public static int getVehicleCount(String stopID) {
        return libtraciJNI.ChargingStation_getVehicleCount(stopID);
    }

    public static StringVector getVehicleIDs(String stopID) {
        return new StringVector(libtraciJNI.ChargingStation_getVehicleIDs(stopID), true);
    }

    public static double getChargingPower(String stopID) {
        return libtraciJNI.ChargingStation_getChargingPower(stopID);
    }

    public static double getEfficiency(String stopID) {
        return libtraciJNI.ChargingStation_getEfficiency(stopID);
    }

    public static double getChargeDelay(String stopID) {
        return libtraciJNI.ChargingStation_getChargeDelay(stopID);
    }

    public static int getChargeInTransit(String stopID) {
        return libtraciJNI.ChargingStation_getChargeInTransit(stopID);
    }

    public static StringVector getIDList() {
        return new StringVector(libtraciJNI.ChargingStation_getIDList(), true);
    }

    public static int getIDCount() {
        return libtraciJNI.ChargingStation_getIDCount();
    }

    public static String getParameter(String objectID, String key) {
        return libtraciJNI.ChargingStation_getParameter(objectID, key);
    }

    public static StringStringPair getParameterWithKey(String objectID, String key) {
        return new StringStringPair(libtraciJNI.ChargingStation_getParameterWithKey(objectID, key), true);
    }

    public static void setParameter(String objectID, String key, String value) {
        libtraciJNI.ChargingStation_setParameter(objectID, key, value);
    }

    public static void subscribe(String objectID, IntVector varIDs, double begin, double end, TraCIResults parameters) {
        libtraciJNI.ChargingStation_subscribe__SWIG_0(objectID, IntVector.getCPtr(varIDs), varIDs, begin, end, TraCIResults.getCPtr(parameters), parameters);
    }

    public static void subscribe(String objectID, IntVector varIDs, double begin, double end) {
        libtraciJNI.ChargingStation_subscribe__SWIG_1(objectID, IntVector.getCPtr(varIDs), varIDs, begin, end);
    }

    public static void subscribe(String objectID, IntVector varIDs, double begin) {
        libtraciJNI.ChargingStation_subscribe__SWIG_2(objectID, IntVector.getCPtr(varIDs), varIDs, begin);
    }

    public static void subscribe(String objectID, IntVector varIDs) {
        libtraciJNI.ChargingStation_subscribe__SWIG_3(objectID, IntVector.getCPtr(varIDs), varIDs);
    }

    public static void subscribe(String objectID) {
        libtraciJNI.ChargingStation_subscribe__SWIG_4(objectID);
    }

    public static void unsubscribe(String objectID) {
        libtraciJNI.ChargingStation_unsubscribe(objectID);
    }

    public static void subscribeContext(String objectID, int domain, double dist, IntVector varIDs, double begin, double end, TraCIResults parameters) {
        libtraciJNI.ChargingStation_subscribeContext__SWIG_0(objectID, domain, dist, IntVector.getCPtr(varIDs), varIDs, begin, end, TraCIResults.getCPtr(parameters), parameters);
    }

    public static void subscribeContext(String objectID, int domain, double dist, IntVector varIDs, double begin, double end) {
        libtraciJNI.ChargingStation_subscribeContext__SWIG_1(objectID, domain, dist, IntVector.getCPtr(varIDs), varIDs, begin, end);
    }

    public static void subscribeContext(String objectID, int domain, double dist, IntVector varIDs, double begin) {
        libtraciJNI.ChargingStation_subscribeContext__SWIG_2(objectID, domain, dist, IntVector.getCPtr(varIDs), varIDs, begin);
    }

    public static void subscribeContext(String objectID, int domain, double dist, IntVector varIDs) {
        libtraciJNI.ChargingStation_subscribeContext__SWIG_3(objectID, domain, dist, IntVector.getCPtr(varIDs), varIDs);
    }

    public static void subscribeContext(String objectID, int domain, double dist) {
        libtraciJNI.ChargingStation_subscribeContext__SWIG_4(objectID, domain, dist);
    }

    public static void unsubscribeContext(String objectID, int domain, double dist) {
        libtraciJNI.ChargingStation_unsubscribeContext(objectID, domain, dist);
    }

    public static SubscriptionResults getAllSubscriptionResults() {
        return new SubscriptionResults(libtraciJNI.ChargingStation_getAllSubscriptionResults(), true);
    }

    public static TraCIResults getSubscriptionResults(String objectID) {
        return new TraCIResults(libtraciJNI.ChargingStation_getSubscriptionResults(objectID), true);
    }

    public static ContextSubscriptionResults getAllContextSubscriptionResults() {
        return new ContextSubscriptionResults(libtraciJNI.ChargingStation_getAllContextSubscriptionResults(), true);
    }

    public static SubscriptionResults getContextSubscriptionResults(String objectID) {
        return new SubscriptionResults(libtraciJNI.ChargingStation_getContextSubscriptionResults(objectID), true);
    }

    public static void subscribeParameterWithKey(String objectID, String key, double beginTime, double endTime) {
        libtraciJNI.ChargingStation_subscribeParameterWithKey__SWIG_0(objectID, key, beginTime, endTime);
    }

    public static void subscribeParameterWithKey(String objectID, String key, double beginTime) {
        libtraciJNI.ChargingStation_subscribeParameterWithKey__SWIG_1(objectID, key, beginTime);
    }

    public static void subscribeParameterWithKey(String objectID, String key) {
        libtraciJNI.ChargingStation_subscribeParameterWithKey__SWIG_2(objectID, key);
    }

    public static int getDOMAIN_ID() {
        return libtraciJNI.ChargingStation_DOMAIN_ID_get();
    }

    public static int domainID() {
        return libtraciJNI.ChargingStation_domainID();
    }

    public static void setChargingPower(String stopID, double power) {
        libtraciJNI.ChargingStation_setChargingPower(stopID, power);
    }

    public static void setEfficiency(String stopID, double efficiency) {
        libtraciJNI.ChargingStation_setEfficiency(stopID, efficiency);
    }

    public static void setChargeDelay(String stopID, double delay) {
        libtraciJNI.ChargingStation_setChargeDelay(stopID, delay);
    }

    public static void setChargeInTransit(String stopID, boolean inTransit) {
        libtraciJNI.ChargingStation_setChargeInTransit(stopID, inTransit);
    }
}

