/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sumo.libtraci;

import org.eclipse.sumo.libtraci.ContextSubscriptionResults;
import org.eclipse.sumo.libtraci.IntVector;
import org.eclipse.sumo.libtraci.StringStringPair;
import org.eclipse.sumo.libtraci.StringVector;
import org.eclipse.sumo.libtraci.SubscriptionResults;
import org.eclipse.sumo.libtraci.TraCIResults;
import org.eclipse.sumo.libtraci.libtraciJNI;

public class Edge {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected Edge(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(Edge obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    protected static long swigRelease(Edge obj) {
        long ptr = 0L;
        if (obj != null) {
            if (!obj.swigCMemOwn) {
                throw new RuntimeException("Cannot release ownership as memory is not owned");
            }
            ptr = obj.swigCPtr;
            obj.swigCMemOwn = false;
            obj.delete();
        }
        return ptr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                libtraciJNI.delete_Edge(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public static double getAdaptedTraveltime(String edgeID, double time) {
        return libtraciJNI.Edge_getAdaptedTraveltime(edgeID, time);
    }

    public static double getEffort(String edgeID, double time) {
        return libtraciJNI.Edge_getEffort(edgeID, time);
    }

    public static double getTraveltime(String edgeID) {
        return libtraciJNI.Edge_getTraveltime(edgeID);
    }

    public static double getWaitingTime(String edgeID) {
        return libtraciJNI.Edge_getWaitingTime(edgeID);
    }

    public static StringVector getLastStepPersonIDs(String edgeID) {
        return new StringVector(libtraciJNI.Edge_getLastStepPersonIDs(edgeID), true);
    }

    public static StringVector getLastStepVehicleIDs(String edgeID) {
        return new StringVector(libtraciJNI.Edge_getLastStepVehicleIDs(edgeID), true);
    }

    public static double getCO2Emission(String edgeID) {
        return libtraciJNI.Edge_getCO2Emission(edgeID);
    }

    public static double getCOEmission(String edgeID) {
        return libtraciJNI.Edge_getCOEmission(edgeID);
    }

    public static double getHCEmission(String edgeID) {
        return libtraciJNI.Edge_getHCEmission(edgeID);
    }

    public static double getPMxEmission(String edgeID) {
        return libtraciJNI.Edge_getPMxEmission(edgeID);
    }

    public static double getNOxEmission(String edgeID) {
        return libtraciJNI.Edge_getNOxEmission(edgeID);
    }

    public static double getFuelConsumption(String edgeID) {
        return libtraciJNI.Edge_getFuelConsumption(edgeID);
    }

    public static double getNoiseEmission(String edgeID) {
        return libtraciJNI.Edge_getNoiseEmission(edgeID);
    }

    public static double getElectricityConsumption(String edgeID) {
        return libtraciJNI.Edge_getElectricityConsumption(edgeID);
    }

    public static int getLastStepVehicleNumber(String edgeID) {
        return libtraciJNI.Edge_getLastStepVehicleNumber(edgeID);
    }

    public static double getLastStepMeanSpeed(String edgeID) {
        return libtraciJNI.Edge_getLastStepMeanSpeed(edgeID);
    }

    public static double getMeanFriction(String edgeID) {
        return libtraciJNI.Edge_getMeanFriction(edgeID);
    }

    public static double getLastStepOccupancy(String edgeID) {
        return libtraciJNI.Edge_getLastStepOccupancy(edgeID);
    }

    public static int getLastStepHaltingNumber(String edgeID) {
        return libtraciJNI.Edge_getLastStepHaltingNumber(edgeID);
    }

    public static double getLastStepLength(String edgeID) {
        return libtraciJNI.Edge_getLastStepLength(edgeID);
    }

    public static int getLaneNumber(String edgeID) {
        return libtraciJNI.Edge_getLaneNumber(edgeID);
    }

    public static String getStreetName(String edgeID) {
        return libtraciJNI.Edge_getStreetName(edgeID);
    }

    public static StringVector getPendingVehicles(String edgeID) {
        return new StringVector(libtraciJNI.Edge_getPendingVehicles(edgeID), true);
    }

    public static double getAngle(String edgeID, double relativePosition) {
        return libtraciJNI.Edge_getAngle__SWIG_0(edgeID, relativePosition);
    }

    public static double getAngle(String edgeID) {
        return libtraciJNI.Edge_getAngle__SWIG_1(edgeID);
    }

    public static String getFromJunction(String edgeID) {
        return libtraciJNI.Edge_getFromJunction(edgeID);
    }

    public static String getToJunction(String edgeID) {
        return libtraciJNI.Edge_getToJunction(edgeID);
    }

    public static String getBidiEdge(String edgeID) {
        return libtraciJNI.Edge_getBidiEdge(edgeID);
    }

    public static StringVector getIDList() {
        return new StringVector(libtraciJNI.Edge_getIDList(), true);
    }

    public static int getIDCount() {
        return libtraciJNI.Edge_getIDCount();
    }

    public static String getParameter(String objectID, String key) {
        return libtraciJNI.Edge_getParameter(objectID, key);
    }

    public static StringStringPair getParameterWithKey(String objectID, String key) {
        return new StringStringPair(libtraciJNI.Edge_getParameterWithKey(objectID, key), true);
    }

    public static void setParameter(String objectID, String key, String value) {
        libtraciJNI.Edge_setParameter(objectID, key, value);
    }

    public static void subscribe(String objectID, IntVector varIDs, double begin, double end, TraCIResults parameters) {
        libtraciJNI.Edge_subscribe__SWIG_0(objectID, IntVector.getCPtr(varIDs), varIDs, begin, end, TraCIResults.getCPtr(parameters), parameters);
    }

    public static void subscribe(String objectID, IntVector varIDs, double begin, double end) {
        libtraciJNI.Edge_subscribe__SWIG_1(objectID, IntVector.getCPtr(varIDs), varIDs, begin, end);
    }

    public static void subscribe(String objectID, IntVector varIDs, double begin) {
        libtraciJNI.Edge_subscribe__SWIG_2(objectID, IntVector.getCPtr(varIDs), varIDs, begin);
    }

    public static void subscribe(String objectID, IntVector varIDs) {
        libtraciJNI.Edge_subscribe__SWIG_3(objectID, IntVector.getCPtr(varIDs), varIDs);
    }

    public static void subscribe(String objectID) {
        libtraciJNI.Edge_subscribe__SWIG_4(objectID);
    }

    public static void unsubscribe(String objectID) {
        libtraciJNI.Edge_unsubscribe(objectID);
    }

    public static void subscribeContext(String objectID, int domain, double dist, IntVector varIDs, double begin, double end, TraCIResults parameters) {
        libtraciJNI.Edge_subscribeContext__SWIG_0(objectID, domain, dist, IntVector.getCPtr(varIDs), varIDs, begin, end, TraCIResults.getCPtr(parameters), parameters);
    }

    public static void subscribeContext(String objectID, int domain, double dist, IntVector varIDs, double begin, double end) {
        libtraciJNI.Edge_subscribeContext__SWIG_1(objectID, domain, dist, IntVector.getCPtr(varIDs), varIDs, begin, end);
    }

    public static void subscribeContext(String objectID, int domain, double dist, IntVector varIDs, double begin) {
        libtraciJNI.Edge_subscribeContext__SWIG_2(objectID, domain, dist, IntVector.getCPtr(varIDs), varIDs, begin);
    }

    public static void subscribeContext(String objectID, int domain, double dist, IntVector varIDs) {
        libtraciJNI.Edge_subscribeContext__SWIG_3(objectID, domain, dist, IntVector.getCPtr(varIDs), varIDs);
    }

    public static void subscribeContext(String objectID, int domain, double dist) {
        libtraciJNI.Edge_subscribeContext__SWIG_4(objectID, domain, dist);
    }

    public static void unsubscribeContext(String objectID, int domain, double dist) {
        libtraciJNI.Edge_unsubscribeContext(objectID, domain, dist);
    }

    public static SubscriptionResults getAllSubscriptionResults() {
        return new SubscriptionResults(libtraciJNI.Edge_getAllSubscriptionResults(), true);
    }

    public static TraCIResults getSubscriptionResults(String objectID) {
        return new TraCIResults(libtraciJNI.Edge_getSubscriptionResults(objectID), true);
    }

    public static ContextSubscriptionResults getAllContextSubscriptionResults() {
        return new ContextSubscriptionResults(libtraciJNI.Edge_getAllContextSubscriptionResults(), true);
    }

    public static SubscriptionResults getContextSubscriptionResults(String objectID) {
        return new SubscriptionResults(libtraciJNI.Edge_getContextSubscriptionResults(objectID), true);
    }

    public static void subscribeParameterWithKey(String objectID, String key, double beginTime, double endTime) {
        libtraciJNI.Edge_subscribeParameterWithKey__SWIG_0(objectID, key, beginTime, endTime);
    }

    public static void subscribeParameterWithKey(String objectID, String key, double beginTime) {
        libtraciJNI.Edge_subscribeParameterWithKey__SWIG_1(objectID, key, beginTime);
    }

    public static void subscribeParameterWithKey(String objectID, String key) {
        libtraciJNI.Edge_subscribeParameterWithKey__SWIG_2(objectID, key);
    }

    public static int getDOMAIN_ID() {
        return libtraciJNI.Edge_DOMAIN_ID_get();
    }

    public static int domainID() {
        return libtraciJNI.Edge_domainID();
    }

    public static void setAllowed(String edgeID, String allowedClasses) {
        libtraciJNI.Edge_setAllowed__SWIG_0(edgeID, allowedClasses);
    }

    public static void setAllowed(String edgeID, StringVector allowedClasses) {
        libtraciJNI.Edge_setAllowed__SWIG_1(edgeID, StringVector.getCPtr(allowedClasses), allowedClasses);
    }

    public static void setDisallowed(String edgeID, String disallowedClasses) {
        libtraciJNI.Edge_setDisallowed__SWIG_0(edgeID, disallowedClasses);
    }

    public static void setDisallowed(String edgeID, StringVector disallowedClasses) {
        libtraciJNI.Edge_setDisallowed__SWIG_1(edgeID, StringVector.getCPtr(disallowedClasses), disallowedClasses);
    }

    public static void adaptTraveltime(String edgeID, double time, double beginSeconds, double endSeconds) {
        libtraciJNI.Edge_adaptTraveltime__SWIG_0(edgeID, time, beginSeconds, endSeconds);
    }

    public static void adaptTraveltime(String edgeID, double time, double beginSeconds) {
        libtraciJNI.Edge_adaptTraveltime__SWIG_1(edgeID, time, beginSeconds);
    }

    public static void adaptTraveltime(String edgeID, double time) {
        libtraciJNI.Edge_adaptTraveltime__SWIG_2(edgeID, time);
    }

    public static void setEffort(String edgeID, double effort, double beginSeconds, double endSeconds) {
        libtraciJNI.Edge_setEffort__SWIG_0(edgeID, effort, beginSeconds, endSeconds);
    }

    public static void setEffort(String edgeID, double effort, double beginSeconds) {
        libtraciJNI.Edge_setEffort__SWIG_1(edgeID, effort, beginSeconds);
    }

    public static void setEffort(String edgeID, double effort) {
        libtraciJNI.Edge_setEffort__SWIG_2(edgeID, effort);
    }

    public static void setMaxSpeed(String edgeID, double speed) {
        libtraciJNI.Edge_setMaxSpeed(edgeID, speed);
    }

    public static void setFriction(String edgeID, double friction) {
        libtraciJNI.Edge_setFriction(edgeID, friction);
    }
}

