/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sumo.libtraci;

import org.eclipse.sumo.libtraci.ContextSubscriptionResults;
import org.eclipse.sumo.libtraci.IntVector;
import org.eclipse.sumo.libtraci.StringStringPair;
import org.eclipse.sumo.libtraci.StringVector;
import org.eclipse.sumo.libtraci.SubscriptionResults;
import org.eclipse.sumo.libtraci.TraCIResults;
import org.eclipse.sumo.libtraci.libtraciJNI;

public class LaneArea {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected LaneArea(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(LaneArea obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    protected static long swigRelease(LaneArea obj) {
        long ptr = 0L;
        if (obj != null) {
            if (!obj.swigCMemOwn) {
                throw new RuntimeException("Cannot release ownership as memory is not owned");
            }
            ptr = obj.swigCPtr;
            obj.swigCMemOwn = false;
            obj.delete();
        }
        return ptr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                libtraciJNI.delete_LaneArea(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public static int getJamLengthVehicle(String detID) {
        return libtraciJNI.LaneArea_getJamLengthVehicle(detID);
    }

    public static double getJamLengthMeters(String detID) {
        return libtraciJNI.LaneArea_getJamLengthMeters(detID);
    }

    public static double getLastStepMeanSpeed(String detID) {
        return libtraciJNI.LaneArea_getLastStepMeanSpeed(detID);
    }

    public static StringVector getLastStepVehicleIDs(String detID) {
        return new StringVector(libtraciJNI.LaneArea_getLastStepVehicleIDs(detID), true);
    }

    public static double getLastStepOccupancy(String detID) {
        return libtraciJNI.LaneArea_getLastStepOccupancy(detID);
    }

    public static double getPosition(String detID) {
        return libtraciJNI.LaneArea_getPosition(detID);
    }

    public static String getLaneID(String detID) {
        return libtraciJNI.LaneArea_getLaneID(detID);
    }

    public static double getLength(String detID) {
        return libtraciJNI.LaneArea_getLength(detID);
    }

    public static int getLastStepVehicleNumber(String detID) {
        return libtraciJNI.LaneArea_getLastStepVehicleNumber(detID);
    }

    public static int getLastStepHaltingNumber(String detID) {
        return libtraciJNI.LaneArea_getLastStepHaltingNumber(detID);
    }

    public static double getIntervalOccupancy(String detID) {
        return libtraciJNI.LaneArea_getIntervalOccupancy(detID);
    }

    public static double getIntervalMeanSpeed(String detID) {
        return libtraciJNI.LaneArea_getIntervalMeanSpeed(detID);
    }

    public static double getIntervalMeanTimeLoss(String detID) {
        return libtraciJNI.LaneArea_getIntervalMeanTimeLoss(detID);
    }

    public static double getIntervalMaxJamLengthInMeters(String detID) {
        return libtraciJNI.LaneArea_getIntervalMaxJamLengthInMeters(detID);
    }

    public static int getIntervalVehicleNumber(String detID) {
        return libtraciJNI.LaneArea_getIntervalVehicleNumber(detID);
    }

    public static double getLastIntervalOccupancy(String detID) {
        return libtraciJNI.LaneArea_getLastIntervalOccupancy(detID);
    }

    public static double getLastIntervalMeanSpeed(String detID) {
        return libtraciJNI.LaneArea_getLastIntervalMeanSpeed(detID);
    }

    public static double getLastIntervalMeanTimeLoss(String detID) {
        return libtraciJNI.LaneArea_getLastIntervalMeanTimeLoss(detID);
    }

    public static double getLastIntervalMaxJamLengthInMeters(String detID) {
        return libtraciJNI.LaneArea_getLastIntervalMaxJamLengthInMeters(detID);
    }

    public static int getLastIntervalVehicleNumber(String detID) {
        return libtraciJNI.LaneArea_getLastIntervalVehicleNumber(detID);
    }

    public static void overrideVehicleNumber(String detID, int vehNum) {
        libtraciJNI.LaneArea_overrideVehicleNumber(detID, vehNum);
    }

    public static StringVector getIDList() {
        return new StringVector(libtraciJNI.LaneArea_getIDList(), true);
    }

    public static int getIDCount() {
        return libtraciJNI.LaneArea_getIDCount();
    }

    public static String getParameter(String objectID, String key) {
        return libtraciJNI.LaneArea_getParameter(objectID, key);
    }

    public static StringStringPair getParameterWithKey(String objectID, String key) {
        return new StringStringPair(libtraciJNI.LaneArea_getParameterWithKey(objectID, key), true);
    }

    public static void setParameter(String objectID, String key, String value) {
        libtraciJNI.LaneArea_setParameter(objectID, key, value);
    }

    public static void subscribe(String objectID, IntVector varIDs, double begin, double end, TraCIResults parameters) {
        libtraciJNI.LaneArea_subscribe__SWIG_0(objectID, IntVector.getCPtr(varIDs), varIDs, begin, end, TraCIResults.getCPtr(parameters), parameters);
    }

    public static void subscribe(String objectID, IntVector varIDs, double begin, double end) {
        libtraciJNI.LaneArea_subscribe__SWIG_1(objectID, IntVector.getCPtr(varIDs), varIDs, begin, end);
    }

    public static void subscribe(String objectID, IntVector varIDs, double begin) {
        libtraciJNI.LaneArea_subscribe__SWIG_2(objectID, IntVector.getCPtr(varIDs), varIDs, begin);
    }

    public static void subscribe(String objectID, IntVector varIDs) {
        libtraciJNI.LaneArea_subscribe__SWIG_3(objectID, IntVector.getCPtr(varIDs), varIDs);
    }

    public static void subscribe(String objectID) {
        libtraciJNI.LaneArea_subscribe__SWIG_4(objectID);
    }

    public static void unsubscribe(String objectID) {
        libtraciJNI.LaneArea_unsubscribe(objectID);
    }

    public static void subscribeContext(String objectID, int domain, double dist, IntVector varIDs, double begin, double end, TraCIResults parameters) {
        libtraciJNI.LaneArea_subscribeContext__SWIG_0(objectID, domain, dist, IntVector.getCPtr(varIDs), varIDs, begin, end, TraCIResults.getCPtr(parameters), parameters);
    }

    public static void subscribeContext(String objectID, int domain, double dist, IntVector varIDs, double begin, double end) {
        libtraciJNI.LaneArea_subscribeContext__SWIG_1(objectID, domain, dist, IntVector.getCPtr(varIDs), varIDs, begin, end);
    }

    public static void subscribeContext(String objectID, int domain, double dist, IntVector varIDs, double begin) {
        libtraciJNI.LaneArea_subscribeContext__SWIG_2(objectID, domain, dist, IntVector.getCPtr(varIDs), varIDs, begin);
    }

    public static void subscribeContext(String objectID, int domain, double dist, IntVector varIDs) {
        libtraciJNI.LaneArea_subscribeContext__SWIG_3(objectID, domain, dist, IntVector.getCPtr(varIDs), varIDs);
    }

    public static void subscribeContext(String objectID, int domain, double dist) {
        libtraciJNI.LaneArea_subscribeContext__SWIG_4(objectID, domain, dist);
    }

    public static void unsubscribeContext(String objectID, int domain, double dist) {
        libtraciJNI.LaneArea_unsubscribeContext(objectID, domain, dist);
    }

    public static SubscriptionResults getAllSubscriptionResults() {
        return new SubscriptionResults(libtraciJNI.LaneArea_getAllSubscriptionResults(), true);
    }

    public static TraCIResults getSubscriptionResults(String objectID) {
        return new TraCIResults(libtraciJNI.LaneArea_getSubscriptionResults(objectID), true);
    }

    public static ContextSubscriptionResults getAllContextSubscriptionResults() {
        return new ContextSubscriptionResults(libtraciJNI.LaneArea_getAllContextSubscriptionResults(), true);
    }

    public static SubscriptionResults getContextSubscriptionResults(String objectID) {
        return new SubscriptionResults(libtraciJNI.LaneArea_getContextSubscriptionResults(objectID), true);
    }

    public static void subscribeParameterWithKey(String objectID, String key, double beginTime, double endTime) {
        libtraciJNI.LaneArea_subscribeParameterWithKey__SWIG_0(objectID, key, beginTime, endTime);
    }

    public static void subscribeParameterWithKey(String objectID, String key, double beginTime) {
        libtraciJNI.LaneArea_subscribeParameterWithKey__SWIG_1(objectID, key, beginTime);
    }

    public static void subscribeParameterWithKey(String objectID, String key) {
        libtraciJNI.LaneArea_subscribeParameterWithKey__SWIG_2(objectID, key);
    }

    public static int getDOMAIN_ID() {
        return libtraciJNI.LaneArea_DOMAIN_ID_get();
    }

    public static int domainID() {
        return libtraciJNI.LaneArea_domainID();
    }
}

