/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sumo.libtraci;

import org.eclipse.sumo.libtraci.ContextSubscriptionResults;
import org.eclipse.sumo.libtraci.IntStringPair;
import org.eclipse.sumo.libtraci.IntVector;
import org.eclipse.sumo.libtraci.SWIGTYPE_p_FILE;
import org.eclipse.sumo.libtraci.SWIGTYPE_p_void;
import org.eclipse.sumo.libtraci.StringStringPair;
import org.eclipse.sumo.libtraci.StringVector;
import org.eclipse.sumo.libtraci.SubscriptionResults;
import org.eclipse.sumo.libtraci.TraCICollisionVector;
import org.eclipse.sumo.libtraci.TraCIPosition;
import org.eclipse.sumo.libtraci.TraCIPositionVector;
import org.eclipse.sumo.libtraci.TraCIResults;
import org.eclipse.sumo.libtraci.TraCIRoadPosition;
import org.eclipse.sumo.libtraci.TraCIStage;
import org.eclipse.sumo.libtraci.TraCIStageVector;
import org.eclipse.sumo.libtraci.libtraciJNI;

public class Simulation {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected Simulation(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(Simulation obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    protected static long swigRelease(Simulation obj) {
        long ptr = 0L;
        if (obj != null) {
            if (!obj.swigCMemOwn) {
                throw new RuntimeException("Cannot release ownership as memory is not owned");
            }
            ptr = obj.swigCPtr;
            obj.swigCMemOwn = false;
            obj.delete();
        }
        return ptr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                libtraciJNI.delete_Simulation(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public static IntStringPair init(int port, int numRetries, String host, String label, SWIGTYPE_p_FILE pipe) {
        return new IntStringPair(libtraciJNI.Simulation_init__SWIG_0(port, numRetries, host, label, SWIGTYPE_p_FILE.getCPtr(pipe)), true);
    }

    public static IntStringPair init(int port, int numRetries, String host, String label) {
        return new IntStringPair(libtraciJNI.Simulation_init__SWIG_1(port, numRetries, host, label), true);
    }

    public static IntStringPair init(int port, int numRetries, String host) {
        return new IntStringPair(libtraciJNI.Simulation_init__SWIG_2(port, numRetries, host), true);
    }

    public static IntStringPair init(int port, int numRetries) {
        return new IntStringPair(libtraciJNI.Simulation_init__SWIG_3(port, numRetries), true);
    }

    public static IntStringPair init(int port) {
        return new IntStringPair(libtraciJNI.Simulation_init__SWIG_4(port), true);
    }

    public static IntStringPair init() {
        return new IntStringPair(libtraciJNI.Simulation_init__SWIG_5(), true);
    }

    public static IntStringPair start(StringVector cmd, int port, int numRetries, String label, boolean verbose, String traceFile, boolean traceGetters, SWIGTYPE_p_void _stdout) {
        return new IntStringPair(libtraciJNI.Simulation_start__SWIG_0(StringVector.getCPtr(cmd), cmd, port, numRetries, label, verbose, traceFile, traceGetters, SWIGTYPE_p_void.getCPtr(_stdout)), true);
    }

    public static IntStringPair start(StringVector cmd, int port, int numRetries, String label, boolean verbose, String traceFile, boolean traceGetters) {
        return new IntStringPair(libtraciJNI.Simulation_start__SWIG_1(StringVector.getCPtr(cmd), cmd, port, numRetries, label, verbose, traceFile, traceGetters), true);
    }

    public static IntStringPair start(StringVector cmd, int port, int numRetries, String label, boolean verbose, String traceFile) {
        return new IntStringPair(libtraciJNI.Simulation_start__SWIG_2(StringVector.getCPtr(cmd), cmd, port, numRetries, label, verbose, traceFile), true);
    }

    public static IntStringPair start(StringVector cmd, int port, int numRetries, String label, boolean verbose) {
        return new IntStringPair(libtraciJNI.Simulation_start__SWIG_3(StringVector.getCPtr(cmd), cmd, port, numRetries, label, verbose), true);
    }

    public static IntStringPair start(StringVector cmd, int port, int numRetries, String label) {
        return new IntStringPair(libtraciJNI.Simulation_start__SWIG_4(StringVector.getCPtr(cmd), cmd, port, numRetries, label), true);
    }

    public static IntStringPair start(StringVector cmd, int port, int numRetries) {
        return new IntStringPair(libtraciJNI.Simulation_start__SWIG_5(StringVector.getCPtr(cmd), cmd, port, numRetries), true);
    }

    public static IntStringPair start(StringVector cmd, int port) {
        return new IntStringPair(libtraciJNI.Simulation_start__SWIG_6(StringVector.getCPtr(cmd), cmd, port), true);
    }

    public static IntStringPair start(StringVector cmd) {
        return new IntStringPair(libtraciJNI.Simulation_start__SWIG_7(StringVector.getCPtr(cmd), cmd), true);
    }

    public static boolean isLibsumo() {
        return libtraciJNI.Simulation_isLibsumo();
    }

    public static void switchConnection(String label) {
        libtraciJNI.Simulation_switchConnection(label);
    }

    public static String getLabel() {
        return libtraciJNI.Simulation_getLabel();
    }

    public static void setOrder(int order) {
        libtraciJNI.Simulation_setOrder(order);
    }

    public static void load(StringVector args) {
        libtraciJNI.Simulation_load(StringVector.getCPtr(args), args);
    }

    public static boolean hasGUI() {
        return libtraciJNI.Simulation_hasGUI();
    }

    public static boolean isLoaded() {
        return libtraciJNI.Simulation_isLoaded();
    }

    public static void step(double time) {
        libtraciJNI.Simulation_step__SWIG_0(time);
    }

    public static void step() {
        libtraciJNI.Simulation_step__SWIG_1();
    }

    public static void executeMove() {
        libtraciJNI.Simulation_executeMove();
    }

    public static void close(String reason) {
        libtraciJNI.Simulation_close__SWIG_0(reason);
    }

    public static void close() {
        libtraciJNI.Simulation_close__SWIG_1();
    }

    public static IntStringPair getVersion() {
        return new IntStringPair(libtraciJNI.Simulation_getVersion(), true);
    }

    public static String getOption(String option) {
        return libtraciJNI.Simulation_getOption(option);
    }

    public static int getCurrentTime() {
        return libtraciJNI.Simulation_getCurrentTime();
    }

    public static double getTime() {
        return libtraciJNI.Simulation_getTime();
    }

    public static double getEndTime() {
        return libtraciJNI.Simulation_getEndTime();
    }

    public static int getLoadedNumber() {
        return libtraciJNI.Simulation_getLoadedNumber();
    }

    public static StringVector getLoadedIDList() {
        return new StringVector(libtraciJNI.Simulation_getLoadedIDList(), true);
    }

    public static int getDepartedNumber() {
        return libtraciJNI.Simulation_getDepartedNumber();
    }

    public static StringVector getDepartedIDList() {
        return new StringVector(libtraciJNI.Simulation_getDepartedIDList(), true);
    }

    public static int getArrivedNumber() {
        return libtraciJNI.Simulation_getArrivedNumber();
    }

    public static StringVector getArrivedIDList() {
        return new StringVector(libtraciJNI.Simulation_getArrivedIDList(), true);
    }

    public static int getParkingStartingVehiclesNumber() {
        return libtraciJNI.Simulation_getParkingStartingVehiclesNumber();
    }

    public static StringVector getParkingStartingVehiclesIDList() {
        return new StringVector(libtraciJNI.Simulation_getParkingStartingVehiclesIDList(), true);
    }

    public static int getParkingEndingVehiclesNumber() {
        return libtraciJNI.Simulation_getParkingEndingVehiclesNumber();
    }

    public static StringVector getParkingEndingVehiclesIDList() {
        return new StringVector(libtraciJNI.Simulation_getParkingEndingVehiclesIDList(), true);
    }

    public static int getStopStartingVehiclesNumber() {
        return libtraciJNI.Simulation_getStopStartingVehiclesNumber();
    }

    public static StringVector getStopStartingVehiclesIDList() {
        return new StringVector(libtraciJNI.Simulation_getStopStartingVehiclesIDList(), true);
    }

    public static int getStopEndingVehiclesNumber() {
        return libtraciJNI.Simulation_getStopEndingVehiclesNumber();
    }

    public static StringVector getStopEndingVehiclesIDList() {
        return new StringVector(libtraciJNI.Simulation_getStopEndingVehiclesIDList(), true);
    }

    public static int getCollidingVehiclesNumber() {
        return libtraciJNI.Simulation_getCollidingVehiclesNumber();
    }

    public static StringVector getCollidingVehiclesIDList() {
        return new StringVector(libtraciJNI.Simulation_getCollidingVehiclesIDList(), true);
    }

    public static int getEmergencyStoppingVehiclesNumber() {
        return libtraciJNI.Simulation_getEmergencyStoppingVehiclesNumber();
    }

    public static StringVector getEmergencyStoppingVehiclesIDList() {
        return new StringVector(libtraciJNI.Simulation_getEmergencyStoppingVehiclesIDList(), true);
    }

    public static int getStartingTeleportNumber() {
        return libtraciJNI.Simulation_getStartingTeleportNumber();
    }

    public static StringVector getStartingTeleportIDList() {
        return new StringVector(libtraciJNI.Simulation_getStartingTeleportIDList(), true);
    }

    public static int getEndingTeleportNumber() {
        return libtraciJNI.Simulation_getEndingTeleportNumber();
    }

    public static StringVector getEndingTeleportIDList() {
        return new StringVector(libtraciJNI.Simulation_getEndingTeleportIDList(), true);
    }

    public static int getDepartedPersonNumber() {
        return libtraciJNI.Simulation_getDepartedPersonNumber();
    }

    public static StringVector getDepartedPersonIDList() {
        return new StringVector(libtraciJNI.Simulation_getDepartedPersonIDList(), true);
    }

    public static int getArrivedPersonNumber() {
        return libtraciJNI.Simulation_getArrivedPersonNumber();
    }

    public static StringVector getArrivedPersonIDList() {
        return new StringVector(libtraciJNI.Simulation_getArrivedPersonIDList(), true);
    }

    public static StringVector getBusStopIDList() {
        return new StringVector(libtraciJNI.Simulation_getBusStopIDList(), true);
    }

    public static int getBusStopWaiting(String stopID) {
        return libtraciJNI.Simulation_getBusStopWaiting(stopID);
    }

    public static StringVector getBusStopWaitingIDList(String stopID) {
        return new StringVector(libtraciJNI.Simulation_getBusStopWaitingIDList(stopID), true);
    }

    public static StringVector getPendingVehicles() {
        return new StringVector(libtraciJNI.Simulation_getPendingVehicles(), true);
    }

    public static TraCICollisionVector getCollisions() {
        return new TraCICollisionVector(libtraciJNI.Simulation_getCollisions(), true);
    }

    public static double getScale() {
        return libtraciJNI.Simulation_getScale();
    }

    public static double getDeltaT() {
        return libtraciJNI.Simulation_getDeltaT();
    }

    public static TraCIPositionVector getNetBoundary() {
        return new TraCIPositionVector(libtraciJNI.Simulation_getNetBoundary(), true);
    }

    public static int getMinExpectedNumber() {
        return libtraciJNI.Simulation_getMinExpectedNumber();
    }

    public static TraCIPosition convert2D(String edgeID, double pos, int laneIndex, boolean toGeo) {
        return new TraCIPosition(libtraciJNI.Simulation_convert2D__SWIG_0(edgeID, pos, laneIndex, toGeo), true);
    }

    public static TraCIPosition convert2D(String edgeID, double pos, int laneIndex) {
        return new TraCIPosition(libtraciJNI.Simulation_convert2D__SWIG_1(edgeID, pos, laneIndex), true);
    }

    public static TraCIPosition convert2D(String edgeID, double pos) {
        return new TraCIPosition(libtraciJNI.Simulation_convert2D__SWIG_2(edgeID, pos), true);
    }

    public static TraCIPosition convert3D(String edgeID, double pos, int laneIndex, boolean toGeo) {
        return new TraCIPosition(libtraciJNI.Simulation_convert3D__SWIG_0(edgeID, pos, laneIndex, toGeo), true);
    }

    public static TraCIPosition convert3D(String edgeID, double pos, int laneIndex) {
        return new TraCIPosition(libtraciJNI.Simulation_convert3D__SWIG_1(edgeID, pos, laneIndex), true);
    }

    public static TraCIPosition convert3D(String edgeID, double pos) {
        return new TraCIPosition(libtraciJNI.Simulation_convert3D__SWIG_2(edgeID, pos), true);
    }

    public static TraCIRoadPosition convertRoad(double x, double y, boolean isGeo, String vClass) {
        return new TraCIRoadPosition(libtraciJNI.Simulation_convertRoad__SWIG_0(x, y, isGeo, vClass), true);
    }

    public static TraCIRoadPosition convertRoad(double x, double y, boolean isGeo) {
        return new TraCIRoadPosition(libtraciJNI.Simulation_convertRoad__SWIG_1(x, y, isGeo), true);
    }

    public static TraCIRoadPosition convertRoad(double x, double y) {
        return new TraCIRoadPosition(libtraciJNI.Simulation_convertRoad__SWIG_2(x, y), true);
    }

    public static TraCIPosition convertGeo(double x, double y, boolean fromGeo) {
        return new TraCIPosition(libtraciJNI.Simulation_convertGeo__SWIG_0(x, y, fromGeo), true);
    }

    public static TraCIPosition convertGeo(double x, double y) {
        return new TraCIPosition(libtraciJNI.Simulation_convertGeo__SWIG_1(x, y), true);
    }

    public static double getDistance2D(double x1, double y1, double x2, double y2, boolean isGeo, boolean isDriving) {
        return libtraciJNI.Simulation_getDistance2D__SWIG_0(x1, y1, x2, y2, isGeo, isDriving);
    }

    public static double getDistance2D(double x1, double y1, double x2, double y2, boolean isGeo) {
        return libtraciJNI.Simulation_getDistance2D__SWIG_1(x1, y1, x2, y2, isGeo);
    }

    public static double getDistance2D(double x1, double y1, double x2, double y2) {
        return libtraciJNI.Simulation_getDistance2D__SWIG_2(x1, y1, x2, y2);
    }

    public static double getDistanceRoad(String edgeID1, double pos1, String edgeID2, double pos2, boolean isDriving) {
        return libtraciJNI.Simulation_getDistanceRoad__SWIG_0(edgeID1, pos1, edgeID2, pos2, isDriving);
    }

    public static double getDistanceRoad(String edgeID1, double pos1, String edgeID2, double pos2) {
        return libtraciJNI.Simulation_getDistanceRoad__SWIG_1(edgeID1, pos1, edgeID2, pos2);
    }

    public static TraCIStage findRoute(String fromEdge, String toEdge, String vType, double depart, int routingMode) {
        return new TraCIStage(libtraciJNI.Simulation_findRoute__SWIG_0(fromEdge, toEdge, vType, depart, routingMode), true);
    }

    public static TraCIStage findRoute(String fromEdge, String toEdge, String vType, double depart) {
        return new TraCIStage(libtraciJNI.Simulation_findRoute__SWIG_1(fromEdge, toEdge, vType, depart), true);
    }

    public static TraCIStage findRoute(String fromEdge, String toEdge, String vType) {
        return new TraCIStage(libtraciJNI.Simulation_findRoute__SWIG_2(fromEdge, toEdge, vType), true);
    }

    public static TraCIStage findRoute(String fromEdge, String toEdge) {
        return new TraCIStage(libtraciJNI.Simulation_findRoute__SWIG_3(fromEdge, toEdge), true);
    }

    public static TraCIStageVector findIntermodalRoute(String fromEdge, String toEdge, String modes, double depart, int routingMode, double speed, double walkFactor, double departPos, double arrivalPos, double departPosLat, String pType, String vType, String destStop) {
        return new TraCIStageVector(libtraciJNI.Simulation_findIntermodalRoute__SWIG_0(fromEdge, toEdge, modes, depart, routingMode, speed, walkFactor, departPos, arrivalPos, departPosLat, pType, vType, destStop), true);
    }

    public static TraCIStageVector findIntermodalRoute(String fromEdge, String toEdge, String modes, double depart, int routingMode, double speed, double walkFactor, double departPos, double arrivalPos, double departPosLat, String pType, String vType) {
        return new TraCIStageVector(libtraciJNI.Simulation_findIntermodalRoute__SWIG_1(fromEdge, toEdge, modes, depart, routingMode, speed, walkFactor, departPos, arrivalPos, departPosLat, pType, vType), true);
    }

    public static TraCIStageVector findIntermodalRoute(String fromEdge, String toEdge, String modes, double depart, int routingMode, double speed, double walkFactor, double departPos, double arrivalPos, double departPosLat, String pType) {
        return new TraCIStageVector(libtraciJNI.Simulation_findIntermodalRoute__SWIG_2(fromEdge, toEdge, modes, depart, routingMode, speed, walkFactor, departPos, arrivalPos, departPosLat, pType), true);
    }

    public static TraCIStageVector findIntermodalRoute(String fromEdge, String toEdge, String modes, double depart, int routingMode, double speed, double walkFactor, double departPos, double arrivalPos, double departPosLat) {
        return new TraCIStageVector(libtraciJNI.Simulation_findIntermodalRoute__SWIG_3(fromEdge, toEdge, modes, depart, routingMode, speed, walkFactor, departPos, arrivalPos, departPosLat), true);
    }

    public static TraCIStageVector findIntermodalRoute(String fromEdge, String toEdge, String modes, double depart, int routingMode, double speed, double walkFactor, double departPos, double arrivalPos) {
        return new TraCIStageVector(libtraciJNI.Simulation_findIntermodalRoute__SWIG_4(fromEdge, toEdge, modes, depart, routingMode, speed, walkFactor, departPos, arrivalPos), true);
    }

    public static TraCIStageVector findIntermodalRoute(String fromEdge, String toEdge, String modes, double depart, int routingMode, double speed, double walkFactor, double departPos) {
        return new TraCIStageVector(libtraciJNI.Simulation_findIntermodalRoute__SWIG_5(fromEdge, toEdge, modes, depart, routingMode, speed, walkFactor, departPos), true);
    }

    public static TraCIStageVector findIntermodalRoute(String fromEdge, String toEdge, String modes, double depart, int routingMode, double speed, double walkFactor) {
        return new TraCIStageVector(libtraciJNI.Simulation_findIntermodalRoute__SWIG_6(fromEdge, toEdge, modes, depart, routingMode, speed, walkFactor), true);
    }

    public static TraCIStageVector findIntermodalRoute(String fromEdge, String toEdge, String modes, double depart, int routingMode, double speed) {
        return new TraCIStageVector(libtraciJNI.Simulation_findIntermodalRoute__SWIG_7(fromEdge, toEdge, modes, depart, routingMode, speed), true);
    }

    public static TraCIStageVector findIntermodalRoute(String fromEdge, String toEdge, String modes, double depart, int routingMode) {
        return new TraCIStageVector(libtraciJNI.Simulation_findIntermodalRoute__SWIG_8(fromEdge, toEdge, modes, depart, routingMode), true);
    }

    public static TraCIStageVector findIntermodalRoute(String fromEdge, String toEdge, String modes, double depart) {
        return new TraCIStageVector(libtraciJNI.Simulation_findIntermodalRoute__SWIG_9(fromEdge, toEdge, modes, depart), true);
    }

    public static TraCIStageVector findIntermodalRoute(String fromEdge, String toEdge, String modes) {
        return new TraCIStageVector(libtraciJNI.Simulation_findIntermodalRoute__SWIG_10(fromEdge, toEdge, modes), true);
    }

    public static TraCIStageVector findIntermodalRoute(String fromEdge, String toEdge) {
        return new TraCIStageVector(libtraciJNI.Simulation_findIntermodalRoute__SWIG_11(fromEdge, toEdge), true);
    }

    public static String getParameter(String objectID, String key) {
        return libtraciJNI.Simulation_getParameter(objectID, key);
    }

    public static StringStringPair getParameterWithKey(String objectID, String key) {
        return new StringStringPair(libtraciJNI.Simulation_getParameterWithKey(objectID, key), true);
    }

    public static void setParameter(String objectID, String key, String value) {
        libtraciJNI.Simulation_setParameter(objectID, key, value);
    }

    public static void setScale(double value) {
        libtraciJNI.Simulation_setScale(value);
    }

    public static void clearPending(String routeID) {
        libtraciJNI.Simulation_clearPending__SWIG_0(routeID);
    }

    public static void clearPending() {
        libtraciJNI.Simulation_clearPending__SWIG_1();
    }

    public static void saveState(String fileName) {
        libtraciJNI.Simulation_saveState(fileName);
    }

    public static double loadState(String fileName) {
        return libtraciJNI.Simulation_loadState(fileName);
    }

    public static void writeMessage(String msg) {
        libtraciJNI.Simulation_writeMessage(msg);
    }

    public static void subscribe(String objectID, IntVector varIDs, double begin, double end, TraCIResults parameters) {
        libtraciJNI.Simulation_subscribe__SWIG_0(objectID, IntVector.getCPtr(varIDs), varIDs, begin, end, TraCIResults.getCPtr(parameters), parameters);
    }

    public static void subscribe(String objectID, IntVector varIDs, double begin, double end) {
        libtraciJNI.Simulation_subscribe__SWIG_1(objectID, IntVector.getCPtr(varIDs), varIDs, begin, end);
    }

    public static void subscribe(String objectID, IntVector varIDs, double begin) {
        libtraciJNI.Simulation_subscribe__SWIG_2(objectID, IntVector.getCPtr(varIDs), varIDs, begin);
    }

    public static void subscribe(String objectID, IntVector varIDs) {
        libtraciJNI.Simulation_subscribe__SWIG_3(objectID, IntVector.getCPtr(varIDs), varIDs);
    }

    public static void subscribe(String objectID) {
        libtraciJNI.Simulation_subscribe__SWIG_4(objectID);
    }

    public static void unsubscribe(String objectID) {
        libtraciJNI.Simulation_unsubscribe(objectID);
    }

    public static void subscribeContext(String objectID, int domain, double dist, IntVector varIDs, double begin, double end, TraCIResults parameters) {
        libtraciJNI.Simulation_subscribeContext__SWIG_0(objectID, domain, dist, IntVector.getCPtr(varIDs), varIDs, begin, end, TraCIResults.getCPtr(parameters), parameters);
    }

    public static void subscribeContext(String objectID, int domain, double dist, IntVector varIDs, double begin, double end) {
        libtraciJNI.Simulation_subscribeContext__SWIG_1(objectID, domain, dist, IntVector.getCPtr(varIDs), varIDs, begin, end);
    }

    public static void subscribeContext(String objectID, int domain, double dist, IntVector varIDs, double begin) {
        libtraciJNI.Simulation_subscribeContext__SWIG_2(objectID, domain, dist, IntVector.getCPtr(varIDs), varIDs, begin);
    }

    public static void subscribeContext(String objectID, int domain, double dist, IntVector varIDs) {
        libtraciJNI.Simulation_subscribeContext__SWIG_3(objectID, domain, dist, IntVector.getCPtr(varIDs), varIDs);
    }

    public static void subscribeContext(String objectID, int domain, double dist) {
        libtraciJNI.Simulation_subscribeContext__SWIG_4(objectID, domain, dist);
    }

    public static void unsubscribeContext(String objectID, int domain, double dist) {
        libtraciJNI.Simulation_unsubscribeContext(objectID, domain, dist);
    }

    public static SubscriptionResults getAllSubscriptionResults() {
        return new SubscriptionResults(libtraciJNI.Simulation_getAllSubscriptionResults(), true);
    }

    public static TraCIResults getSubscriptionResults(String objectID) {
        return new TraCIResults(libtraciJNI.Simulation_getSubscriptionResults__SWIG_0(objectID), true);
    }

    public static ContextSubscriptionResults getAllContextSubscriptionResults() {
        return new ContextSubscriptionResults(libtraciJNI.Simulation_getAllContextSubscriptionResults(), true);
    }

    public static SubscriptionResults getContextSubscriptionResults(String objectID) {
        return new SubscriptionResults(libtraciJNI.Simulation_getContextSubscriptionResults(objectID), true);
    }

    public static void subscribeParameterWithKey(String objectID, String key, double beginTime, double endTime) {
        libtraciJNI.Simulation_subscribeParameterWithKey__SWIG_0(objectID, key, beginTime, endTime);
    }

    public static void subscribeParameterWithKey(String objectID, String key, double beginTime) {
        libtraciJNI.Simulation_subscribeParameterWithKey__SWIG_1(objectID, key, beginTime);
    }

    public static void subscribeParameterWithKey(String objectID, String key) {
        libtraciJNI.Simulation_subscribeParameterWithKey__SWIG_2(objectID, key);
    }

    public static int getDOMAIN_ID() {
        return libtraciJNI.Simulation_DOMAIN_ID_get();
    }

    public static int domainID() {
        return libtraciJNI.Simulation_domainID();
    }

    public static void subscribe(IntVector varIDs, double begin, double end, TraCIResults parameters) {
        libtraciJNI.Simulation_subscribe__SWIG_5(IntVector.getCPtr(varIDs), varIDs, begin, end, TraCIResults.getCPtr(parameters), parameters);
    }

    public static void subscribe(IntVector varIDs, double begin, double end) {
        libtraciJNI.Simulation_subscribe__SWIG_6(IntVector.getCPtr(varIDs), varIDs, begin, end);
    }

    public static void subscribe(IntVector varIDs, double begin) {
        libtraciJNI.Simulation_subscribe__SWIG_7(IntVector.getCPtr(varIDs), varIDs, begin);
    }

    public static void subscribe(IntVector varIDs) {
        libtraciJNI.Simulation_subscribe__SWIG_8(IntVector.getCPtr(varIDs), varIDs);
    }

    public static void subscribe() {
        libtraciJNI.Simulation_subscribe__SWIG_9();
    }

    public static TraCIResults getSubscriptionResults() {
        return new TraCIResults(libtraciJNI.Simulation_getSubscriptionResults__SWIG_1(), true);
    }

    public static void preloadLibraries() {
        if (Runtime.Version.parse(System.getProperty("java.version")).compareTo(Runtime.Version.parse("21.0.5")) < 0) {
            System.err.println("The recommended minimal Java version is 21.0.5.");
        }
        System.loadLibrary("libtracijni");
    }
}

