/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sumo.libsumo;

import org.eclipse.sumo.libsumo.ContextSubscriptionResults;
import org.eclipse.sumo.libsumo.IntVector;
import org.eclipse.sumo.libsumo.StringStringPair;
import org.eclipse.sumo.libsumo.StringVector;
import org.eclipse.sumo.libsumo.SubscriptionResults;
import org.eclipse.sumo.libsumo.TraCIResults;
import org.eclipse.sumo.libsumo.libsumoJNI;

public class Edge {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected Edge(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(Edge obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    protected static long swigRelease(Edge obj) {
        long ptr = 0L;
        if (obj != null) {
            if (!obj.swigCMemOwn) {
                throw new RuntimeException("Cannot release ownership as memory is not owned");
            }
            ptr = obj.swigCPtr;
            obj.swigCMemOwn = false;
            obj.delete();
        }
        return ptr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                libsumoJNI.delete_Edge(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public static double getAdaptedTraveltime(String edgeID, double time) {
        return libsumoJNI.Edge_getAdaptedTraveltime(edgeID, time);
    }

    public static double getEffort(String edgeID, double time) {
        return libsumoJNI.Edge_getEffort(edgeID, time);
    }

    public static double getTraveltime(String edgeID) {
        return libsumoJNI.Edge_getTraveltime(edgeID);
    }

    public static double getWaitingTime(String edgeID) {
        return libsumoJNI.Edge_getWaitingTime(edgeID);
    }

    public static StringVector getLastStepPersonIDs(String edgeID) {
        return new StringVector(libsumoJNI.Edge_getLastStepPersonIDs(edgeID), true);
    }

    public static StringVector getLastStepVehicleIDs(String edgeID) {
        return new StringVector(libsumoJNI.Edge_getLastStepVehicleIDs(edgeID), true);
    }

    public static double getCO2Emission(String edgeID) {
        return libsumoJNI.Edge_getCO2Emission(edgeID);
    }

    public static double getCOEmission(String edgeID) {
        return libsumoJNI.Edge_getCOEmission(edgeID);
    }

    public static double getHCEmission(String edgeID) {
        return libsumoJNI.Edge_getHCEmission(edgeID);
    }

    public static double getPMxEmission(String edgeID) {
        return libsumoJNI.Edge_getPMxEmission(edgeID);
    }

    public static double getNOxEmission(String edgeID) {
        return libsumoJNI.Edge_getNOxEmission(edgeID);
    }

    public static double getFuelConsumption(String edgeID) {
        return libsumoJNI.Edge_getFuelConsumption(edgeID);
    }

    public static double getNoiseEmission(String edgeID) {
        return libsumoJNI.Edge_getNoiseEmission(edgeID);
    }

    public static double getElectricityConsumption(String edgeID) {
        return libsumoJNI.Edge_getElectricityConsumption(edgeID);
    }

    public static int getLastStepVehicleNumber(String edgeID) {
        return libsumoJNI.Edge_getLastStepVehicleNumber(edgeID);
    }

    public static double getLastStepMeanSpeed(String edgeID) {
        return libsumoJNI.Edge_getLastStepMeanSpeed(edgeID);
    }

    public static double getMeanFriction(String edgeID) {
        return libsumoJNI.Edge_getMeanFriction(edgeID);
    }

    public static double getLastStepOccupancy(String edgeID) {
        return libsumoJNI.Edge_getLastStepOccupancy(edgeID);
    }

    public static int getLastStepHaltingNumber(String edgeID) {
        return libsumoJNI.Edge_getLastStepHaltingNumber(edgeID);
    }

    public static double getLastStepLength(String edgeID) {
        return libsumoJNI.Edge_getLastStepLength(edgeID);
    }

    public static int getLaneNumber(String edgeID) {
        return libsumoJNI.Edge_getLaneNumber(edgeID);
    }

    public static String getStreetName(String edgeID) {
        return libsumoJNI.Edge_getStreetName(edgeID);
    }

    public static StringVector getPendingVehicles(String edgeID) {
        return new StringVector(libsumoJNI.Edge_getPendingVehicles(edgeID), true);
    }

    public static double getAngle(String edgeID, double relativePosition) {
        return libsumoJNI.Edge_getAngle__SWIG_0(edgeID, relativePosition);
    }

    public static double getAngle(String edgeID) {
        return libsumoJNI.Edge_getAngle__SWIG_1(edgeID);
    }

    public static String getFromJunction(String edgeID) {
        return libsumoJNI.Edge_getFromJunction(edgeID);
    }

    public static String getToJunction(String edgeID) {
        return libsumoJNI.Edge_getToJunction(edgeID);
    }

    public static String getBidiEdge(String edgeID) {
        return libsumoJNI.Edge_getBidiEdge(edgeID);
    }

    public static StringVector getIDList() {
        return new StringVector(libsumoJNI.Edge_getIDList(), true);
    }

    public static int getIDCount() {
        return libsumoJNI.Edge_getIDCount();
    }

    public static String getParameter(String objectID, String key) {
        return libsumoJNI.Edge_getParameter(objectID, key);
    }

    public static StringStringPair getParameterWithKey(String objectID, String key) {
        return new StringStringPair(libsumoJNI.Edge_getParameterWithKey(objectID, key), true);
    }

    public static void setParameter(String objectID, String key, String value) {
        libsumoJNI.Edge_setParameter(objectID, key, value);
    }

    public static void subscribe(String objectID, IntVector varIDs, double begin, double end, TraCIResults parameters) {
        libsumoJNI.Edge_subscribe__SWIG_0(objectID, IntVector.getCPtr(varIDs), varIDs, begin, end, TraCIResults.getCPtr(parameters), parameters);
    }

    public static void subscribe(String objectID, IntVector varIDs, double begin, double end) {
        libsumoJNI.Edge_subscribe__SWIG_1(objectID, IntVector.getCPtr(varIDs), varIDs, begin, end);
    }

    public static void subscribe(String objectID, IntVector varIDs, double begin) {
        libsumoJNI.Edge_subscribe__SWIG_2(objectID, IntVector.getCPtr(varIDs), varIDs, begin);
    }

    public static void subscribe(String objectID, IntVector varIDs) {
        libsumoJNI.Edge_subscribe__SWIG_3(objectID, IntVector.getCPtr(varIDs), varIDs);
    }

    public static void subscribe(String objectID) {
        libsumoJNI.Edge_subscribe__SWIG_4(objectID);
    }

    public static void unsubscribe(String objectID) {
        libsumoJNI.Edge_unsubscribe(objectID);
    }

    public static void subscribeContext(String objectID, int domain, double dist, IntVector varIDs, double begin, double end, TraCIResults parameters) {
        libsumoJNI.Edge_subscribeContext__SWIG_0(objectID, domain, dist, IntVector.getCPtr(varIDs), varIDs, begin, end, TraCIResults.getCPtr(parameters), parameters);
    }

    public static void subscribeContext(String objectID, int domain, double dist, IntVector varIDs, double begin, double end) {
        libsumoJNI.Edge_subscribeContext__SWIG_1(objectID, domain, dist, IntVector.getCPtr(varIDs), varIDs, begin, end);
    }

    public static void subscribeContext(String objectID, int domain, double dist, IntVector varIDs, double begin) {
        libsumoJNI.Edge_subscribeContext__SWIG_2(objectID, domain, dist, IntVector.getCPtr(varIDs), varIDs, begin);
    }

    public static void subscribeContext(String objectID, int domain, double dist, IntVector varIDs) {
        libsumoJNI.Edge_subscribeContext__SWIG_3(objectID, domain, dist, IntVector.getCPtr(varIDs), varIDs);
    }

    public static void subscribeContext(String objectID, int domain, double dist) {
        libsumoJNI.Edge_subscribeContext__SWIG_4(objectID, domain, dist);
    }

    public static void unsubscribeContext(String objectID, int domain, double dist) {
        libsumoJNI.Edge_unsubscribeContext(objectID, domain, dist);
    }

    public static SubscriptionResults getAllSubscriptionResults() {
        return new SubscriptionResults(libsumoJNI.Edge_getAllSubscriptionResults(), true);
    }

    public static TraCIResults getSubscriptionResults(String objectID) {
        return new TraCIResults(libsumoJNI.Edge_getSubscriptionResults(objectID), true);
    }

    public static ContextSubscriptionResults getAllContextSubscriptionResults() {
        return new ContextSubscriptionResults(libsumoJNI.Edge_getAllContextSubscriptionResults(), true);
    }

    public static SubscriptionResults getContextSubscriptionResults(String objectID) {
        return new SubscriptionResults(libsumoJNI.Edge_getContextSubscriptionResults(objectID), true);
    }

    public static void subscribeParameterWithKey(String objectID, String key, double beginTime, double endTime) {
        libsumoJNI.Edge_subscribeParameterWithKey__SWIG_0(objectID, key, beginTime, endTime);
    }

    public static void subscribeParameterWithKey(String objectID, String key, double beginTime) {
        libsumoJNI.Edge_subscribeParameterWithKey__SWIG_1(objectID, key, beginTime);
    }

    public static void subscribeParameterWithKey(String objectID, String key) {
        libsumoJNI.Edge_subscribeParameterWithKey__SWIG_2(objectID, key);
    }

    public static int getDOMAIN_ID() {
        return libsumoJNI.Edge_DOMAIN_ID_get();
    }

    public static int domainID() {
        return libsumoJNI.Edge_domainID();
    }

    public static void setAllowed(String edgeID, String allowedClasses) {
        libsumoJNI.Edge_setAllowed__SWIG_0(edgeID, allowedClasses);
    }

    public static void setAllowed(String edgeID, StringVector allowedClasses) {
        libsumoJNI.Edge_setAllowed__SWIG_1(edgeID, StringVector.getCPtr(allowedClasses), allowedClasses);
    }

    public static void setDisallowed(String edgeID, String disallowedClasses) {
        libsumoJNI.Edge_setDisallowed__SWIG_0(edgeID, disallowedClasses);
    }

    public static void setDisallowed(String edgeID, StringVector disallowedClasses) {
        libsumoJNI.Edge_setDisallowed__SWIG_1(edgeID, StringVector.getCPtr(disallowedClasses), disallowedClasses);
    }

    public static void adaptTraveltime(String edgeID, double time, double beginSeconds, double endSeconds) {
        libsumoJNI.Edge_adaptTraveltime__SWIG_0(edgeID, time, beginSeconds, endSeconds);
    }

    public static void adaptTraveltime(String edgeID, double time, double beginSeconds) {
        libsumoJNI.Edge_adaptTraveltime__SWIG_1(edgeID, time, beginSeconds);
    }

    public static void adaptTraveltime(String edgeID, double time) {
        libsumoJNI.Edge_adaptTraveltime__SWIG_2(edgeID, time);
    }

    public static void setEffort(String edgeID, double effort, double beginSeconds, double endSeconds) {
        libsumoJNI.Edge_setEffort__SWIG_0(edgeID, effort, beginSeconds, endSeconds);
    }

    public static void setEffort(String edgeID, double effort, double beginSeconds) {
        libsumoJNI.Edge_setEffort__SWIG_1(edgeID, effort, beginSeconds);
    }

    public static void setEffort(String edgeID, double effort) {
        libsumoJNI.Edge_setEffort__SWIG_2(edgeID, effort);
    }

    public static void setMaxSpeed(String edgeID, double speed) {
        libsumoJNI.Edge_setMaxSpeed(edgeID, speed);
    }

    public static void setFriction(String edgeID, double friction) {
        libsumoJNI.Edge_setFriction(edgeID, friction);
    }
}

