/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sumo.libsumo;

import org.eclipse.sumo.libsumo.ContextSubscriptionResults;
import org.eclipse.sumo.libsumo.DoubleVector;
import org.eclipse.sumo.libsumo.IntVector;
import org.eclipse.sumo.libsumo.StringStringPair;
import org.eclipse.sumo.libsumo.StringVector;
import org.eclipse.sumo.libsumo.SubscriptionResults;
import org.eclipse.sumo.libsumo.TraCIColor;
import org.eclipse.sumo.libsumo.TraCIPositionVector;
import org.eclipse.sumo.libsumo.TraCIResults;
import org.eclipse.sumo.libsumo.libsumoJNI;

public class Polygon {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected Polygon(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(Polygon obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    protected static long swigRelease(Polygon obj) {
        long ptr = 0L;
        if (obj != null) {
            if (!obj.swigCMemOwn) {
                throw new RuntimeException("Cannot release ownership as memory is not owned");
            }
            ptr = obj.swigCPtr;
            obj.swigCMemOwn = false;
            obj.delete();
        }
        return ptr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                libsumoJNI.delete_Polygon(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public static String getType(String polygonID) {
        return libsumoJNI.Polygon_getType(polygonID);
    }

    public static TraCIPositionVector getShape(String polygonID) {
        return new TraCIPositionVector(libsumoJNI.Polygon_getShape(polygonID), true);
    }

    public static TraCIColor getColor(String polygonID) {
        return new TraCIColor(libsumoJNI.Polygon_getColor(polygonID), true);
    }

    public static boolean getFilled(String polygonID) {
        return libsumoJNI.Polygon_getFilled(polygonID);
    }

    public static double getLineWidth(String polygonID) {
        return libsumoJNI.Polygon_getLineWidth(polygonID);
    }

    public static StringVector getIDList() {
        return new StringVector(libsumoJNI.Polygon_getIDList(), true);
    }

    public static int getIDCount() {
        return libsumoJNI.Polygon_getIDCount();
    }

    public static String getParameter(String objectID, String key) {
        return libsumoJNI.Polygon_getParameter(objectID, key);
    }

    public static StringStringPair getParameterWithKey(String objectID, String key) {
        return new StringStringPair(libsumoJNI.Polygon_getParameterWithKey(objectID, key), true);
    }

    public static void setParameter(String objectID, String key, String value) {
        libsumoJNI.Polygon_setParameter(objectID, key, value);
    }

    public static void subscribe(String objectID, IntVector varIDs, double begin, double end, TraCIResults parameters) {
        libsumoJNI.Polygon_subscribe__SWIG_0(objectID, IntVector.getCPtr(varIDs), varIDs, begin, end, TraCIResults.getCPtr(parameters), parameters);
    }

    public static void subscribe(String objectID, IntVector varIDs, double begin, double end) {
        libsumoJNI.Polygon_subscribe__SWIG_1(objectID, IntVector.getCPtr(varIDs), varIDs, begin, end);
    }

    public static void subscribe(String objectID, IntVector varIDs, double begin) {
        libsumoJNI.Polygon_subscribe__SWIG_2(objectID, IntVector.getCPtr(varIDs), varIDs, begin);
    }

    public static void subscribe(String objectID, IntVector varIDs) {
        libsumoJNI.Polygon_subscribe__SWIG_3(objectID, IntVector.getCPtr(varIDs), varIDs);
    }

    public static void subscribe(String objectID) {
        libsumoJNI.Polygon_subscribe__SWIG_4(objectID);
    }

    public static void unsubscribe(String objectID) {
        libsumoJNI.Polygon_unsubscribe(objectID);
    }

    public static void subscribeContext(String objectID, int domain, double dist, IntVector varIDs, double begin, double end, TraCIResults parameters) {
        libsumoJNI.Polygon_subscribeContext__SWIG_0(objectID, domain, dist, IntVector.getCPtr(varIDs), varIDs, begin, end, TraCIResults.getCPtr(parameters), parameters);
    }

    public static void subscribeContext(String objectID, int domain, double dist, IntVector varIDs, double begin, double end) {
        libsumoJNI.Polygon_subscribeContext__SWIG_1(objectID, domain, dist, IntVector.getCPtr(varIDs), varIDs, begin, end);
    }

    public static void subscribeContext(String objectID, int domain, double dist, IntVector varIDs, double begin) {
        libsumoJNI.Polygon_subscribeContext__SWIG_2(objectID, domain, dist, IntVector.getCPtr(varIDs), varIDs, begin);
    }

    public static void subscribeContext(String objectID, int domain, double dist, IntVector varIDs) {
        libsumoJNI.Polygon_subscribeContext__SWIG_3(objectID, domain, dist, IntVector.getCPtr(varIDs), varIDs);
    }

    public static void subscribeContext(String objectID, int domain, double dist) {
        libsumoJNI.Polygon_subscribeContext__SWIG_4(objectID, domain, dist);
    }

    public static void unsubscribeContext(String objectID, int domain, double dist) {
        libsumoJNI.Polygon_unsubscribeContext(objectID, domain, dist);
    }

    public static SubscriptionResults getAllSubscriptionResults() {
        return new SubscriptionResults(libsumoJNI.Polygon_getAllSubscriptionResults(), true);
    }

    public static TraCIResults getSubscriptionResults(String objectID) {
        return new TraCIResults(libsumoJNI.Polygon_getSubscriptionResults(objectID), true);
    }

    public static ContextSubscriptionResults getAllContextSubscriptionResults() {
        return new ContextSubscriptionResults(libsumoJNI.Polygon_getAllContextSubscriptionResults(), true);
    }

    public static SubscriptionResults getContextSubscriptionResults(String objectID) {
        return new SubscriptionResults(libsumoJNI.Polygon_getContextSubscriptionResults(objectID), true);
    }

    public static void subscribeParameterWithKey(String objectID, String key, double beginTime, double endTime) {
        libsumoJNI.Polygon_subscribeParameterWithKey__SWIG_0(objectID, key, beginTime, endTime);
    }

    public static void subscribeParameterWithKey(String objectID, String key, double beginTime) {
        libsumoJNI.Polygon_subscribeParameterWithKey__SWIG_1(objectID, key, beginTime);
    }

    public static void subscribeParameterWithKey(String objectID, String key) {
        libsumoJNI.Polygon_subscribeParameterWithKey__SWIG_2(objectID, key);
    }

    public static int getDOMAIN_ID() {
        return libsumoJNI.Polygon_DOMAIN_ID_get();
    }

    public static int domainID() {
        return libsumoJNI.Polygon_domainID();
    }

    public static void setType(String polygonID, String polygonType) {
        libsumoJNI.Polygon_setType(polygonID, polygonType);
    }

    public static void setShape(String polygonID, TraCIPositionVector shape) {
        libsumoJNI.Polygon_setShape(polygonID, TraCIPositionVector.getCPtr(shape), shape);
    }

    public static void setColor(String polygonID, TraCIColor color) {
        libsumoJNI.Polygon_setColor(polygonID, TraCIColor.getCPtr(color), color);
    }

    public static void add(String polygonID, TraCIPositionVector shape, TraCIColor color, boolean fill, String polygonType, int layer, double lineWidth) {
        libsumoJNI.Polygon_add__SWIG_0(polygonID, TraCIPositionVector.getCPtr(shape), shape, TraCIColor.getCPtr(color), color, fill, polygonType, layer, lineWidth);
    }

    public static void add(String polygonID, TraCIPositionVector shape, TraCIColor color, boolean fill, String polygonType, int layer) {
        libsumoJNI.Polygon_add__SWIG_1(polygonID, TraCIPositionVector.getCPtr(shape), shape, TraCIColor.getCPtr(color), color, fill, polygonType, layer);
    }

    public static void add(String polygonID, TraCIPositionVector shape, TraCIColor color, boolean fill, String polygonType) {
        libsumoJNI.Polygon_add__SWIG_2(polygonID, TraCIPositionVector.getCPtr(shape), shape, TraCIColor.getCPtr(color), color, fill, polygonType);
    }

    public static void add(String polygonID, TraCIPositionVector shape, TraCIColor color, boolean fill) {
        libsumoJNI.Polygon_add__SWIG_3(polygonID, TraCIPositionVector.getCPtr(shape), shape, TraCIColor.getCPtr(color), color, fill);
    }

    public static void add(String polygonID, TraCIPositionVector shape, TraCIColor color) {
        libsumoJNI.Polygon_add__SWIG_4(polygonID, TraCIPositionVector.getCPtr(shape), shape, TraCIColor.getCPtr(color), color);
    }

    public static void addDynamics(String polygonID, String trackedObjectID, DoubleVector timeSpan, DoubleVector alphaSpan, boolean looped, boolean rotate) {
        libsumoJNI.Polygon_addDynamics__SWIG_0(polygonID, trackedObjectID, DoubleVector.getCPtr(timeSpan), timeSpan, DoubleVector.getCPtr(alphaSpan), alphaSpan, looped, rotate);
    }

    public static void addDynamics(String polygonID, String trackedObjectID, DoubleVector timeSpan, DoubleVector alphaSpan, boolean looped) {
        libsumoJNI.Polygon_addDynamics__SWIG_1(polygonID, trackedObjectID, DoubleVector.getCPtr(timeSpan), timeSpan, DoubleVector.getCPtr(alphaSpan), alphaSpan, looped);
    }

    public static void addDynamics(String polygonID, String trackedObjectID, DoubleVector timeSpan, DoubleVector alphaSpan) {
        libsumoJNI.Polygon_addDynamics__SWIG_2(polygonID, trackedObjectID, DoubleVector.getCPtr(timeSpan), timeSpan, DoubleVector.getCPtr(alphaSpan), alphaSpan);
    }

    public static void addDynamics(String polygonID, String trackedObjectID, DoubleVector timeSpan) {
        libsumoJNI.Polygon_addDynamics__SWIG_3(polygonID, trackedObjectID, DoubleVector.getCPtr(timeSpan), timeSpan);
    }

    public static void addDynamics(String polygonID, String trackedObjectID) {
        libsumoJNI.Polygon_addDynamics__SWIG_4(polygonID, trackedObjectID);
    }

    public static void addDynamics(String polygonID) {
        libsumoJNI.Polygon_addDynamics__SWIG_5(polygonID);
    }

    public static void remove(String polygonID, int layer) {
        libsumoJNI.Polygon_remove__SWIG_0(polygonID, layer);
    }

    public static void remove(String polygonID) {
        libsumoJNI.Polygon_remove__SWIG_1(polygonID);
    }

    public static void setFilled(String polygonID, boolean filled) {
        libsumoJNI.Polygon_setFilled(polygonID, filled);
    }

    public static void setLineWidth(String polygonID, double lineWidth) {
        libsumoJNI.Polygon_setLineWidth(polygonID, lineWidth);
    }
}

