/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sumo.libsumo;

import java.util.AbstractList;
import java.util.RandomAccess;
import org.eclipse.sumo.libsumo.TraCIReservation;
import org.eclipse.sumo.libsumo.libsumoJNI;

public class TraCIReservationVector
extends AbstractList<TraCIReservation>
implements RandomAccess {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected TraCIReservationVector(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(TraCIReservationVector obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    protected static long swigRelease(TraCIReservationVector obj) {
        long ptr = 0L;
        if (obj != null) {
            if (!obj.swigCMemOwn) {
                throw new RuntimeException("Cannot release ownership as memory is not owned");
            }
            ptr = obj.swigCPtr;
            obj.swigCMemOwn = false;
            obj.delete();
        }
        return ptr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                libsumoJNI.delete_TraCIReservationVector(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public TraCIReservationVector(TraCIReservation[] initialElements) {
        this();
        this.reserve(initialElements.length);
        for (TraCIReservation element : initialElements) {
            this.add(element);
        }
    }

    public TraCIReservationVector(Iterable<TraCIReservation> initialElements) {
        this();
        for (TraCIReservation element : initialElements) {
            this.add(element);
        }
    }

    @Override
    public TraCIReservation get(int index) {
        return this.doGet(index);
    }

    @Override
    public TraCIReservation set(int index, TraCIReservation e) {
        return this.doSet(index, e);
    }

    @Override
    public boolean add(TraCIReservation e) {
        ++this.modCount;
        this.doAdd(e);
        return true;
    }

    @Override
    public void add(int index, TraCIReservation e) {
        ++this.modCount;
        this.doAdd(index, e);
    }

    @Override
    public TraCIReservation remove(int index) {
        ++this.modCount;
        return this.doRemove(index);
    }

    @Override
    protected void removeRange(int fromIndex, int toIndex) {
        ++this.modCount;
        this.doRemoveRange(fromIndex, toIndex);
    }

    @Override
    public int size() {
        return this.doSize();
    }

    public int capacity() {
        return this.doCapacity();
    }

    public void reserve(int n) {
        this.doReserve(n);
    }

    public TraCIReservationVector() {
        this(libsumoJNI.new_TraCIReservationVector__SWIG_0(), true);
    }

    public TraCIReservationVector(TraCIReservationVector other) {
        this(libsumoJNI.new_TraCIReservationVector__SWIG_1(TraCIReservationVector.getCPtr(other), other), true);
    }

    @Override
    public boolean isEmpty() {
        return libsumoJNI.TraCIReservationVector_isEmpty(this.swigCPtr, this);
    }

    @Override
    public void clear() {
        libsumoJNI.TraCIReservationVector_clear(this.swigCPtr, this);
    }

    public TraCIReservationVector(int count, TraCIReservation value) {
        this(libsumoJNI.new_TraCIReservationVector__SWIG_2(count, TraCIReservation.getCPtr(value), value), true);
    }

    private int doCapacity() {
        return libsumoJNI.TraCIReservationVector_doCapacity(this.swigCPtr, this);
    }

    private void doReserve(int n) {
        libsumoJNI.TraCIReservationVector_doReserve(this.swigCPtr, this, n);
    }

    private int doSize() {
        return libsumoJNI.TraCIReservationVector_doSize(this.swigCPtr, this);
    }

    private void doAdd(TraCIReservation x) {
        libsumoJNI.TraCIReservationVector_doAdd__SWIG_0(this.swigCPtr, this, TraCIReservation.getCPtr(x), x);
    }

    private void doAdd(int index, TraCIReservation x) {
        libsumoJNI.TraCIReservationVector_doAdd__SWIG_1(this.swigCPtr, this, index, TraCIReservation.getCPtr(x), x);
    }

    private TraCIReservation doRemove(int index) {
        return new TraCIReservation(libsumoJNI.TraCIReservationVector_doRemove(this.swigCPtr, this, index), true);
    }

    private TraCIReservation doGet(int index) {
        return new TraCIReservation(libsumoJNI.TraCIReservationVector_doGet(this.swigCPtr, this, index), true);
    }

    private TraCIReservation doSet(int index, TraCIReservation val) {
        return new TraCIReservation(libsumoJNI.TraCIReservationVector_doSet(this.swigCPtr, this, index, TraCIReservation.getCPtr(val), val), true);
    }

    private void doRemoveRange(int fromIndex, int toIndex) {
        libsumoJNI.TraCIReservationVector_doRemoveRange(this.swigCPtr, this, fromIndex, toIndex);
    }
}

