/*
 * Decompiled with CFR 0.152.
 */
package de.tudresden.sumo.cmd;

import de.tudresden.sumo.objects.SumoColor;
import de.tudresden.sumo.objects.SumoStringList;
import de.tudresden.sumo.util.SumoCommand;

public class Person {
    public static SumoCommand add(String personID, String edgeID, double pos, double depart, String typeID) {
        Object[] array = new Object[]{typeID, edgeID, depart, pos};
        return new SumoCommand(206, 128, (Object)personID, array);
    }

    public static SumoCommand appendWaitingStage(String personID, double duration, String description, String stopID) {
        Object[] array = new Object[]{1, duration, description, stopID};
        return new SumoCommand(206, 196, (Object)personID, array);
    }

    public static SumoCommand appendWalkingStage(String personID, SumoStringList edges, double arrivalPos, double duration, double speed, String stopID) {
        Object[] array = new Object[]{2, edges, arrivalPos, duration, speed, stopID};
        return new SumoCommand(206, 196, (Object)personID, array);
    }

    public static SumoCommand appendDrivingStage(String personID, String toEdge, String lines, String stopID) {
        Object[] array = new Object[]{3, toEdge, lines, stopID};
        return new SumoCommand(206, 196, (Object)personID, array);
    }

    public static SumoCommand removeStage(String personID, int nextStageIndex) {
        return new SumoCommand(206, 197, (Object)personID, nextStageIndex);
    }

    public static SumoCommand setSpeed(String personID, double speed) {
        return new SumoCommand(206, 64, (Object)personID, speed);
    }

    public static SumoCommand setType(String personID, String typeID) {
        return new SumoCommand(206, 79, (Object)personID, typeID);
    }

    public static SumoCommand setWidth(String personID, double width) {
        return new SumoCommand(206, 77, (Object)personID, width);
    }

    public static SumoCommand setHeight(String personID, double height) {
        return new SumoCommand(206, 188, (Object)personID, height);
    }

    public static SumoCommand setLength(String personID, double length) {
        return new SumoCommand(206, 68, (Object)personID, length);
    }

    public static SumoCommand setMinGap(String personID, double minGap) {
        return new SumoCommand(206, 76, (Object)personID, minGap);
    }

    public static SumoCommand setColor(String personID, SumoColor color) {
        return new SumoCommand(206, 69, (Object)personID, color);
    }

    public static SumoCommand getColor(String personID) {
        return new SumoCommand(174, 69, personID, 190, 17);
    }

    public static SumoCommand getLength(String personID) {
        return new SumoCommand(174, 68, personID, 190, 11);
    }

    public static SumoCommand getWaitingTime(String personID) {
        return new SumoCommand(174, 122, personID, 190, 11);
    }

    public static SumoCommand getWidth(String personID) {
        return new SumoCommand(174, 77, personID, 190, 11);
    }

    public static SumoCommand getNextEdge(String personID) {
        return new SumoCommand(174, 76, personID, 190, 12);
    }

    public static SumoCommand getEdges(String personID) {
        return new SumoCommand(174, 193, personID, 190, 14);
    }

    public static SumoCommand getEdges(String personID, int nextStageIndex) {
        Object[] array = new Object[]{nextStageIndex};
        return new SumoCommand(174, 84, (Object)personID, array, 190, 14);
    }

    public static SumoCommand getStage(String personID, int nextStageIndex) {
        Object[] array = new Object[]{nextStageIndex};
        return new SumoCommand(174, 192, (Object)personID, array, 190, 15);
    }

    public static SumoCommand getRemainingStages(String personID) {
        return new SumoCommand(174, 194, personID, 190, 9);
    }

    public static SumoCommand getVehicle(String personID) {
        return new SumoCommand(174, 195, personID, 190, 12);
    }

    public static SumoCommand getLanePosition(String personID) {
        return new SumoCommand(174, 86, personID, 190, 11);
    }

    public static SumoCommand getIDCount() {
        return new SumoCommand(174, 1, "", 190, 9);
    }

    public static SumoCommand getIDList() {
        return new SumoCommand(174, 0, "", 190, 14);
    }

    public static SumoCommand getParameter(String personID, String param) {
        Object[] array = new Object[]{param};
        return new SumoCommand(174, 126, (Object)personID, array, 190, 12);
    }

    public static SumoCommand setParameter(String personID, String param, String value) {
        Object[] array = new Object[]{param, value};
        return new SumoCommand(206, 126, (Object)personID, array);
    }

    public static SumoCommand getSpeed(String personID) {
        return new SumoCommand(174, 64, personID, 190, 11);
    }

    public static SumoCommand getPosition(String personID) {
        return new SumoCommand(174, 66, personID, 190, 1);
    }

    public static SumoCommand getPosition3D(String personID) {
        return new SumoCommand(174, 57, personID, 190, 3);
    }

    public static SumoCommand getAngle(String personID) {
        return new SumoCommand(174, 67, personID, 190, 11);
    }

    public static SumoCommand getRoadID(String personID) {
        return new SumoCommand(174, 80, personID, 190, 12);
    }

    public static SumoCommand getTypeID(String personID) {
        return new SumoCommand(174, 79, personID, 190, 12);
    }

    public static SumoCommand getPersonNumber(String personID) {
        return new SumoCommand(174, 103, personID, 190, 9);
    }

    public static SumoCommand getMinGap(String personID) {
        return new SumoCommand(174, 76, personID, 190, 11);
    }

    public static SumoCommand rerouteTraveltime(String personID) {
        Object[] array = new Object[]{personID};
        return new SumoCommand(206, 144, (Object)personID, array);
    }

    public static SumoCommand moveToXY(String personID, String edgeID, double x, double y, double angle, byte keepRoute) {
        Object[] array = new Object[]{edgeID, x, y, angle, keepRoute};
        return new SumoCommand(206, 180, (Object)personID, array);
    }
}

