/*
 * Decompiled with CFR 0.152.
 */
package de.tudresden.sumo.subscription;

import de.tudresden.sumo.subscription.Subscription;
import de.tudresden.sumo.subscription.SubscriptionContext;
import de.tudresden.sumo.subscription.SumoDomain;
import it.polito.appeal.traci.protocol.Command;
import java.util.LinkedList;

public class ContextSubscription
implements Subscription {
    public SubscriptionContext context;
    public double start;
    public double stop;
    public String objectID;
    public SumoDomain contextDomain;
    public double contextRange;
    public LinkedList<Integer> commands;

    public ContextSubscription() {
        this.context = SubscriptionContext.lane;
        this.start = 0.0;
        this.stop = 6000000.0;
        this.objectID = "gneE0_0";
        this.contextDomain = SumoDomain.vehicles;
        this.contextRange = 100.0;
        this.commands = new LinkedList();
        this.commands.add(66);
        this.commands.add(64);
    }

    public ContextSubscription(SubscriptionContext context, double start, double stop, String objectID, SumoDomain contextDomain, double contextRange) {
        this.context = context;
        this.start = start;
        this.stop = stop;
        this.objectID = objectID;
        this.contextDomain = contextDomain;
        this.contextRange = contextRange;
        this.commands = new LinkedList();
    }

    public void addCommand(int cmd) {
        this.commands.add(cmd);
    }

    @Override
    public Command getCommand() {
        Command cmd = new Command(this.context.id);
        cmd.content().writeDouble(this.start);
        cmd.content().writeDouble(this.stop);
        cmd.content().writeStringASCII(this.objectID);
        cmd.content().writeUnsignedByte(this.contextDomain.id);
        cmd.content().writeDouble(this.contextRange);
        cmd.content().writeUnsignedByte(this.commands.size());
        for (Integer ix : this.commands) {
            cmd.content().writeUnsignedByte(ix);
        }
        return cmd;
    }
}

