/*
 * Decompiled with CFR 0.152.
 */
package de.tudresden.sumo.util;

import de.tudresden.sumo.objects.SumoObject;
import de.tudresden.sumo.subscription.ResponseType;
import de.tudresden.sumo.subscription.SubscriptionObject;
import de.tudresden.sumo.util.CommandProcessor;
import de.tudresden.sumo.util.Observable;
import de.uniluebeck.itm.tcpip.Storage;
import it.polito.appeal.traci.TraCIException;
import it.polito.appeal.traci.protocol.Command;
import it.polito.appeal.traci.protocol.RequestMessage;
import it.polito.appeal.traci.protocol.ResponseContainer;
import it.polito.appeal.traci.protocol.ResponseMessage;
import it.polito.appeal.traci.protocol.StatusResponse;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.util.List;

public abstract class Query
extends Observable {
    private final DataOutputStream outStream;
    private final DataInputStream inStream;

    public Query(Socket sock) throws IOException {
        this.outStream = new DataOutputStream(sock.getOutputStream());
        this.inStream = new DataInputStream(sock.getInputStream());
    }

    protected ResponseMessage doQuery(RequestMessage msg) throws IOException {
        msg.writeTo(this.getOutStream());
        return new ResponseMessage(this.inStream);
    }

    protected ResponseMessage queryAndVerify(RequestMessage reqMsg) throws IOException {
        reqMsg.writeTo(this.getOutStream());
        ResponseMessage respMsg = new ResponseMessage(this.inStream);
        List<Command> commands = reqMsg.commands();
        List<ResponseContainer> responses = respMsg.responses();
        if (commands.size() > responses.size()) {
            throw new TraCIException("not enough responses received");
        }
        for (int i = 0; i < commands.size(); ++i) {
            Command cmd = commands.get(i);
            ResponseContainer responsePair = responses.get(i);
            StatusResponse statusResp = responsePair.getStatus();
            Query.verify("command and status IDs match", (Object)cmd.id(), statusResp.id());
            if (statusResp.result() == 0) continue;
            throw new TraCIException("SUMO error for command " + statusResp.id() + ": " + statusResp.description());
        }
        return respMsg;
    }

    protected ResponseContainer doQuerySingle(Command request) throws IOException {
        RequestMessage msg = new RequestMessage();
        msg.append(request);
        ResponseMessage resp = this.doQuery(msg);
        return resp.responses().iterator().next();
    }

    protected void doSetOrder(int index) throws IOException {
        Command cmd = new Command(3);
        cmd.content().writeInt(index);
        this.queryAndVerifySingle(cmd);
    }

    protected void doClose() throws IOException {
        Command cmd = new Command(127);
        this.queryAndVerifySingle(cmd);
    }

    protected void doSimulationStep(double targetTime) throws IOException {
        Command cmd = new Command(2);
        cmd.content().writeDouble(targetTime);
        RequestMessage msg = new RequestMessage();
        msg.append(cmd);
        msg.writeTo(this.getOutStream());
        int totalLen = this.inStream.readInt() - 4;
        byte[] buffer = new byte[totalLen];
        this.inStream.readFully(buffer);
        Storage s = new Storage(buffer);
        for (int i = 0; i < 7; ++i) {
            s.readUnsignedByte();
        }
        int count = s.readInt();
        for (int i = 0; i < count; ++i) {
            short response;
            ResponseType rt;
            int length = s.readUnsignedByte();
            if (length == 0) {
                length = s.readInt();
            }
            if ((rt = ResponseType.getType(response = s.readUnsignedByte())) == ResponseType.UNKNOWN) continue;
            String id = s.readStringASCII();
            if (rt.isContext()) {
                short domain = s.readUnsignedByte();
                int Variable_Count = s.readUnsignedByte();
                int Object_Count = s.readInt();
                for (int oc = 0; oc < Object_Count; ++oc) {
                    String name = s.readStringASCII();
                    for (int vc = 0; vc < Variable_Count; ++vc) {
                        short variable = s.readUnsignedByte();
                        short status = s.readUnsignedByte();
                        short return_type = s.readUnsignedByte();
                        SumoObject o = CommandProcessor.read(return_type, s);
                        SubscriptionObject so = new SubscriptionObject(id, rt, domain, name, variable, status, return_type, o);
                        this.notifyObservers(so);
                    }
                }
                continue;
            }
            int Variable_Count = s.readUnsignedByte();
            for (int vc = 0; vc < Variable_Count; ++vc) {
                short variable = s.readUnsignedByte();
                short status = s.readUnsignedByte();
                short return_type = s.readUnsignedByte();
                SumoObject o = CommandProcessor.read(return_type, s);
                SubscriptionObject so = new SubscriptionObject(id, rt, variable, status, return_type, o);
                this.notifyObservers(so);
            }
        }
    }

    protected ResponseContainer queryAndVerifySingle(Command request) throws IOException {
        RequestMessage msg = new RequestMessage();
        msg.append(request);
        ResponseMessage resp = this.queryAndVerify(msg);
        return resp.responses().iterator().next();
    }

    protected void fireAndForget(Command request) {
        try {
            RequestMessage msg = new RequestMessage();
            msg.append(request);
            msg.writeTo(this.outStream);
            int totalLen = this.inStream.readInt() - 4;
            byte[] buffer = new byte[totalLen];
            this.inStream.readFully(buffer);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected static String verifyGetVarResponse(Command resp, int commandID, int variable, String objectID) throws TraCIException.UnexpectedData {
        Query.verify("response code", (Object)commandID, resp.id());
        Query.verify("variable ID", (Object)variable, (Object)resp.content().readUnsignedByte());
        String respObjectID = resp.content().readStringASCII();
        if (objectID != null) {
            Query.verify("object ID", objectID, respObjectID);
        }
        return respObjectID;
    }

    protected static void verify(String description, Object expected, Object actual) throws TraCIException.UnexpectedData {
        if (!actual.equals(expected)) {
            throw new TraCIException.UnexpectedData(description, expected, actual);
        }
    }

    protected static void verify(String description, int expected, short actual) throws TraCIException.UnexpectedData {
        Query.verify(description, (Object)expected, (Object)actual);
    }

    protected static void verify(String description, int expected, byte actual) throws TraCIException.UnexpectedData {
        Query.verify(description, (Object)expected, (Object)actual);
    }

    public DataOutputStream getOutStream() {
        return this.outStream;
    }
}

