/*
 * Decompiled with CFR 0.152.
 */
package it.polito.appeal.traci.protocol;

import de.uniluebeck.itm.tcpip.Storage;

public class Command {
    private static final int HEADER_SIZE = 6;
    private final int id;
    private final Storage content;

    public Command(Storage rawStorage) {
        int contentLen = rawStorage.readUnsignedByte();
        contentLen = contentLen == 0 ? rawStorage.readInt() - 6 : (contentLen -= 2);
        this.id = rawStorage.readUnsignedByte();
        short[] buf = new short[contentLen];
        for (int i = 0; i < contentLen; ++i) {
            buf[i] = (byte)rawStorage.readUnsignedByte();
        }
        this.content = new Storage(buf);
    }

    public Command(int id) {
        if (id > 255) {
            throw new IllegalArgumentException("id should fit in a byte");
        }
        this.content = new Storage();
        this.id = id;
    }

    public int id() {
        return this.id;
    }

    public Storage content() {
        return this.content;
    }

    public void writeRawTo(Storage out) {
        out.writeByte(0);
        out.writeInt(6 + this.content.size());
        out.writeUnsignedByte(this.id);
        for (Byte b : this.content.getStorageList()) {
            out.writeByte(b.byteValue());
        }
    }

    public int rawSize() {
        return 6 + this.content.size();
    }
}

