/*
 * Decompiled with CFR 0.152.
 */
package it.polito.appeal.traci.protocol;

import de.uniluebeck.itm.tcpip.Storage;
import it.polito.appeal.traci.protocol.Command;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.zip.Checksum;

public class RequestMessage {
    private final List<Command> commands = new ArrayList<Command>();

    public void append(Command c) {
        if (c == null) {
            throw new NullPointerException("the command can't be null");
        }
        this.commands.add(c);
    }

    public void writeTo(DataOutputStream dos) throws IOException {
        int totalLen = 4;
        for (Command cmd : this.commands) {
            totalLen += cmd.rawSize();
        }
        Checksum checksum = null;
        dos.writeInt(totalLen);
        for (Command cmd : this.commands) {
            Storage s = new Storage();
            cmd.writeRawTo(s);
            this.writeStorage(s, dos, checksum);
        }
    }

    private void writeStorage(Storage storage, OutputStream os, Checksum checksum) throws IOException {
        byte[] buf = new byte[storage.getStorageList().size()];
        int n = 0;
        for (Byte b : storage.getStorageList()) {
            if (checksum != null) {
                checksum.update(b.byteValue());
            }
            buf[n] = b;
            ++n;
        }
        os.write(buf);
    }

    public List<Command> commands() {
        return Collections.unmodifiableList(this.commands);
    }
}

