/*
 * Decompiled with CFR 0.152.
 */
package it.polito.appeal.traci.protocol;

import de.uniluebeck.itm.tcpip.Storage;
import it.polito.appeal.traci.protocol.Command;
import it.polito.appeal.traci.protocol.ResponseContainer;
import it.polito.appeal.traci.protocol.StatusResponse;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ResponseMessage {
    public static final int[] STATUS_ONLY_RESPONSES = new int[]{127, 3, 202, 204, 195, 206, 199, 200, 198, 203, 194, 196, 197};
    private List<ResponseContainer> pairs = new ArrayList<ResponseContainer>();

    public ResponseMessage(DataInputStream dis) throws IOException {
        int totalLen = dis.readInt() - 4;
        byte[] buffer = new byte[totalLen];
        dis.readFully(buffer);
        Storage s = new Storage(buffer);
        while (s.validPos()) {
            ResponseContainer responseContainer;
            StatusResponse sr = new StatusResponse(s);
            if (sr.result() != 0) {
                responseContainer = new ResponseContainer(sr, null);
            } else if (sr.id() == 2) {
                int nSubResponses = s.readInt();
                ArrayList<Command> subResponses = new ArrayList<Command>(nSubResponses);
                for (int i = 0; i < nSubResponses; ++i) {
                    subResponses.add(new Command(s));
                }
                responseContainer = new ResponseContainer(sr, null, subResponses);
            } else {
                responseContainer = this.isStatusOnlyResponse(sr.id()) ? new ResponseContainer(sr, null) : new ResponseContainer(sr, new Command(s));
            }
            this.pairs.add(responseContainer);
        }
    }

    private boolean isStatusOnlyResponse(int statusResponseID) {
        for (int id : STATUS_ONLY_RESPONSES) {
            if (id != statusResponseID) continue;
            return true;
        }
        return false;
    }

    public List<ResponseContainer> responses() {
        return Collections.unmodifiableList(this.pairs);
    }
}

