/*
 * Decompiled with CFR 0.152.
 */
package de.dlr.ts.commons.logger;

import de.dlr.ts.commons.logger.DLRLogger;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;

class WriteToDisk {
    private String logFolder = "log";
    private final String LOG_FILE_EXT = ".log";
    private final long LOG_REFRESH_RATE = 10000L;
    private List<Line> logLines = Collections.synchronizedList(new ArrayList());
    private double logFolderSizeLimitMB = 0.0;
    private final SimpleDateFormat sdf = new SimpleDateFormat("yyyy_MM_dd");
    private long todayTime;
    private String currentFileName = "";
    private Timer cleanerTimer;
    private Timer writerTimer;
    private TimerTask writerTask = new TimerTask(){

        @Override
        public void run() {
            String new_;
            String old_ = WriteToDisk.this.sdf.format(new Date(WriteToDisk.this.todayTime));
            if (!old_.equals(new_ = WriteToDisk.this.sdf.format(new Date(System.currentTimeMillis())))) {
                WriteToDisk.this.setCurrentFileName();
                WriteToDisk.this.todayTime = System.currentTimeMillis();
            }
            WriteToDisk.this.writeToDisk();
            WriteToDisk.this.cleanList();
        }
    };
    private TimerTask cleanerTask = new TimerTask(){

        @Override
        public void run() {
            if (WriteToDisk.this.logFolderSizeLimitMB == 0.0) {
                return;
            }
            File _logFolder = new File(WriteToDisk.this.logFolder);
            if (!_logFolder.exists()) {
                return;
            }
            while (WriteToDisk.this.getFolderSize(_logFolder) > WriteToDisk.this.logFolderSizeLimitMB) {
                WriteToDisk.this.deleteOldestLogFile();
            }
        }
    };

    public WriteToDisk(double maxSize) {
        this.logFolderSizeLimitMB = maxSize;
        if (this.logFolderSizeLimitMB != 0.0) {
            DLRLogger.finer((Object)this, "Setting logFolderSizeLimit to " + this.logFolderSizeLimitMB + "MB");
        }
    }

    public void start() {
        if (this.logFolderSizeLimitMB != 0.0) {
            this.cleanerTimer = new Timer(true);
            this.cleanerTimer.schedule(this.cleanerTask, 0L, 43200000L);
        }
        this.todayTime = System.currentTimeMillis();
        this.setCurrentFileName();
        this.writerTimer = new Timer(true);
        this.writerTimer.schedule(this.writerTask, 10000L, 10000L);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                WriteToDisk.this.writeToDisk();
            }
        });
    }

    public synchronized void addLogLine(String line) {
        if (this.logLines.size() < 10000) {
            this.logLines.add(new Line(line));
        }
    }

    private void setCurrentFileName() {
        if (!new File(this.logFolder).exists()) {
            new File(this.logFolder).mkdir();
        }
        this.currentFileName = this.logFolder + File.separator + this.getNewFileName() + ".log";
        if (!this.wasCleanedToday()) {
            this.cleanLogFolder();
        }
    }

    private String getNewFileName() {
        int biggest = 0;
        boolean exist = false;
        String name = this.sdf.format(new Date(System.currentTimeMillis()));
        for (String s : new File(this.logFolder).list()) {
            if (!s.contains(name) || !s.endsWith(".log")) continue;
            exist = true;
            String tmp = s.replace(name, "").replace(".", "").replace("log", "").trim();
            try {
                if (tmp.isEmpty() || biggest >= Integer.valueOf(tmp)) continue;
                biggest = Integer.valueOf(tmp);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (exist) {
            return name + "." + String.format("%03d", ++biggest);
        }
        return name + "." + String.format("%03d", biggest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void writeToDisk() {
        if (this.logLines.isEmpty()) {
            return;
        }
        OutputStreamWriter fr = null;
        try {
            fr = new FileWriter(new File(this.currentFileName), true);
            for (Line ll : this.logLines) {
                fr.append(ll.line);
                fr.append(System.getProperty("line.separator"));
                ll.processed = true;
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                fr.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    private synchronized void cleanList() {
        Iterator<Line> i = this.logLines.iterator();
        while (i.hasNext()) {
            if (!i.next().processed) continue;
            i.remove();
        }
    }

    private boolean wasCleanedToday() {
        String name = this.sdf.format(new Date(System.currentTimeMillis()));
        for (String s : new File(this.logFolder).list()) {
            if (!s.contains(name)) continue;
            return true;
        }
        return false;
    }

    public void setLogFolder(String logFolder) {
        File parent;
        File file = new File(logFolder);
        if (!(file = new File(file.getAbsolutePath())).getName().equals("log")) {
            file = new File(file.getAbsolutePath() + File.separator + "log");
        }
        if (!(parent = new File(file.getParent())).exists()) {
            DLRLogger.severe((Object)this, "Log Folder could not be set, setting default: " + new File("").getAbsolutePath() + File.separator + "log");
        }
    }

    private void cleanLogFolder() {
        if (this.logFolderSizeLimitMB == 0.0) {
            return;
        }
        File _logFolder = new File(this.logFolder);
        if (!_logFolder.exists()) {
            return;
        }
        while (this.getFolderSize(_logFolder) > this.logFolderSizeLimitMB) {
            this.deleteOldestLogFile();
        }
    }

    private double getFolderSize(File folder) {
        double size = 0.0;
        for (File file : folder.listFiles()) {
            size += (double)file.length();
        }
        return size / 1048576.0;
    }

    private void deleteOldestLogFile() {
        File _logFolder = new File(this.logFolder);
        List<String> asList = Arrays.asList(_logFolder.list());
        Collections.sort(asList);
        File file = new File(this.logFolder + "/" + asList.get(0));
        file.delete();
    }

    private static void sleepi(long time) {
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static class Line {
        String line;
        boolean processed = false;

        public Line(String line) {
            this.line = line;
        }

        public String toString() {
            return this.line;
        }
    }
}

