/*
 * Decompiled with CFR 0.152.
 */
package de.dlr.ts.commons.tools;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FileTools {
    static final Charset ENCODING = StandardCharsets.UTF_8;

    private FileTools() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File source, File dest) throws IOException {
        InputStream is = null;
        OutputStream os = null;
        try {
            int length;
            is = new FileInputStream(source);
            os = new FileOutputStream(dest);
            byte[] buffer = new byte[1024];
            while ((length = is.read(buffer)) > 0) {
                os.write(buffer, 0, length);
            }
        }
        finally {
            is.close();
            os.close();
        }
    }

    public static boolean createFile(String path) throws IOException {
        FileTools.createDirectories(path);
        File file = new File(path);
        boolean cc = file.createNewFile();
        return cc;
    }

    public static void delete(File f) throws IOException {
        if (f.isDirectory()) {
            for (File c : f.listFiles()) {
                FileTools.delete(c);
            }
        }
        if (!f.delete()) {
            throw new FileNotFoundException("Failed to delete file: " + f);
        }
    }

    public static void createDirectories(String path) {
        File kk = new File(path);
        String parent = kk.getParent();
        File file = new File(parent);
        file.mkdirs();
    }

    public static String cleanDirectoryName(String dir) {
        if (dir == null) {
            return null;
        }
        if (dir.endsWith("/") || dir.endsWith("\\")) {
            dir = dir.substring(0, dir.length() - 1);
        }
        if (dir.startsWith("/") || dir.startsWith("\\")) {
            dir = dir.substring(1, dir.length());
        }
        return dir;
    }

    public static void appendToTextFile(String fileName, String ... lines) throws IOException {
        File file = new File(fileName);
        if (!file.exists()) {
            FileTools.createFile(fileName);
        }
        FileWriter fw = new FileWriter(file, true);
        for (String line : lines) {
            fw.append(line);
            fw.append(System.lineSeparator());
        }
        fw.close();
    }

    public static byte[] readBinaryFile(String fileName) {
        try {
            File file = new File(fileName);
            FileInputStream insputStream = new FileInputStream(file);
            long length = file.length();
            byte[] bytes = new byte[(int)length];
            ((InputStream)insputStream).read(bytes);
            return bytes;
        }
        catch (Exception e) {
            Logger.getLogger(FileTools.class.getName()).log(Level.SEVERE, null, e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeBinaryFile(String fileName, byte[] data) {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(fileName);
            fos.write(data, 0, data.length);
            fos.flush();
            fos.close();
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(FileTools.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(FileTools.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                fos.close();
            }
            catch (IOException ex) {
                Logger.getLogger(FileTools.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public static List<String> readSmallTextFile(String fileName) throws IOException {
        Path path = Paths.get(fileName, new String[0]);
        return Files.readAllLines(path, ENCODING);
    }

    public static void writeSmallTextFile(String fileName, List<String> lines) throws IOException {
        Path path = Paths.get(fileName, new String[0]);
        Files.write(path, lines, ENCODING, new OpenOption[0]);
    }

    public static void writeSmallTextFile(String fileName, String text) throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        lines.addAll(Arrays.asList(text.split("\n")));
        Path path = Paths.get(fileName, new String[0]);
        Files.write(path, lines, ENCODING, new OpenOption[0]);
    }

    public static void writeLargerTextFile(String fileName, List<String> lines) throws IOException {
        Path path = Paths.get(fileName, new String[0]);
        BufferedWriter writer = Files.newBufferedWriter(path, ENCODING, new OpenOption[0]);
        for (String line : lines) {
            writer.write(line);
            writer.newLine();
        }
        writer.close();
    }

    public static String getFolder(String fileName) {
        File file = new File(fileName);
        file = new File(file.getAbsolutePath());
        return file.getParent();
    }
}

