/*
 * Decompiled with CFR 0.152.
 */
package de.dlr.ts.commons.tools;

import java.util.Arrays;
import java.util.List;

public class StringTools {
    public static String repeatChar(String charToRepeat, int times) {
        String ret = "";
        for (int i = 0; i < times; ++i) {
            ret = ret + charToRepeat;
        }
        return ret;
    }

    public static String centerText(String text, int width) {
        int head = (width - text.length()) / 2;
        String ret = StringTools.repeatChar(" ", head);
        ret = ret + text;
        ret = ret + StringTools.repeatChar(" ", width - (head + text.length()));
        return ret;
    }

    public static String centerText(String text, int width, String borders) {
        return borders + StringTools.centerText(text, width - borders.length() * 2) + borders;
    }

    public static String alignLeft(String text, int width, String borders) {
        int space = width - (borders.length() + 1 + text.length() + borders.length());
        return borders + " " + text + StringTools.repeatChar(" ", space) + borders;
    }

    public static String alignLeft(String text, int width) {
        int space = width - (1 + text.length());
        return " " + text + StringTools.repeatChar(" ", space);
    }

    public static String alignRight(String text, int width, String borders) {
        int space = width - (borders.length() + 1 + text.length() + borders.length());
        return borders + " " + StringTools.repeatChar(" ", space) + text + borders;
    }

    public static String align(String text, int width, String direction) {
        if (direction.equalsIgnoreCase("L")) {
            return StringTools.alignLeft(text, width);
        }
        if (direction.equalsIgnoreCase("R")) {
            return StringTools.alignRight(text, width);
        }
        return StringTools.centerText(text, width);
    }

    public static String align(int text, int width, String direction) {
        return StringTools.align("" + text, width, direction);
    }

    public static String alignRight(String text, int width) {
        int space = width - (1 + text.length());
        return " " + StringTools.repeatChar(" ", space) + text;
    }

    public static String centerAndFillWithChar(String text, char charToFillWith, int length) {
        int i;
        if (text.length() + 2 > length) {
            return text;
        }
        String tmp = " " + text + " ";
        int rest = length - (text.length() + 2);
        for (i = 0; i < rest / 2; ++i) {
            tmp = charToFillWith + tmp;
        }
        for (i = 0; i < rest / 2 + rest % 2; ++i) {
            tmp = tmp + charToFillWith;
        }
        return tmp;
    }

    public static String alignLeftAndFillWithChar(String text, char charToFillWith, int length) {
        if (text.length() + 1 > length) {
            return text;
        }
        String tmp = text + " ";
        for (int i = 0; i < length - (text.length() + 1); ++i) {
            tmp = tmp + charToFillWith;
        }
        return tmp;
    }

    public static String alignRightAndFillWithChar(String text, char charToFillWith, int length) {
        if (text.length() + 1 > length) {
            return text;
        }
        String tmp = " " + text;
        for (int i = 0; i < length - (text.length() + 1); ++i) {
            tmp = charToFillWith + tmp;
        }
        return tmp;
    }

    @Deprecated
    public static String fillStringWithChars(String originalString, String chars, int i) {
        String ret = "";
        for (int j = 0; j < i - originalString.length(); ++j) {
            ret = ret + chars;
        }
        return ret;
    }

    public static List<String> convertStringToList(String string) {
        return Arrays.asList(string.split(System.lineSeparator()));
    }
}

