/*
 * Decompiled with CFR 0.152.
 */
package de.dlr.ts.lisum;

import de.dlr.ts.commons.logger.DLRLogger;
import de.dlr.ts.commons.logger.LogLevel;
import de.dlr.ts.commons.tools.FileTools;
import de.dlr.ts.lisum.Constants;
import de.dlr.ts.lisum.SplashScreen;
import de.dlr.ts.lisum.interfaces.ControlUnitInterface;
import de.dlr.ts.lisum.interfaces.SignalProgramInterface;
import de.dlr.ts.lisum.lisa.Lisa;
import de.dlr.ts.lisum.simulation.LisumSimulation;
import de.dlr.ts.utils.xmladmin2.MalformedKeyOrNameException;
import de.dlr.ts.utils.xmladmin2.XMLAdmin2;
import de.dlr.ts.utils.xmladmin2.XMLNode;
import de.dlr.ts.utils.xmladmin2.XMLNodeNotFoundException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xml.sax.SAXException;

public class Main {
    private String sumoExec = "sumo";
    private String sumoConfig = null;
    private final int sumoPort = 9100;
    private String lisaRestFulServerDir = "localhost";
    private final int lisaPort = 9091;
    private String lisumFile = "";
    private String loggingLevel = "INFO";
    private LisumSimulation ls;
    private boolean pause = false;

    public static void main(String[] args) throws Exception {
        SplashScreen sc = new SplashScreen("LiSuM 1.0.1");
        sc.setYear(2018);
        sc.addRuntimeOption("-log               ", "logging level", "INFO");
        sc.addRuntimeOption("-f or -file        ", "lisum_xml Project file", "");
        sc.addRuntimeOption("-c or -conf        ", "config file", "");
        sc.addRuntimeOption("-s or -sumoexec    ", "sumo executable", "");
        sc.addRuntimeOption("-S or -sumocfg     ", "sumo configuration", "");
        sc.addRuntimeOption("-p                 ", "Pause before starting", "");
        sc.addRuntimeOption("-lisa-version or -L", "Supported LISA version", "7.2");
        sc.showSplashScreen();
        new Main().start(args);
    }

    private void readConfFile(String file) {
        DLRLogger.info("Reading config file: " + file.trim());
        try {
            List<String> f = FileTools.readSmallTextFile(file);
            StringBuilder sb = new StringBuilder();
            for (String string : f) {
                if (string.trim().startsWith("#")) continue;
                sb.append(string + " ");
            }
            this.readConf(sb.toString().split(" "));
        }
        catch (IOException ex) {
            Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void readConf(String[] args) {
        args = this.cleanArray(args);
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-conf") || args[i].equals("-c")) {
                this.readConfFile(args[i + 1]);
            }
            if (args[i].equals("-sumoexec") || args[i].equals("-s")) {
                this.sumoExec = args[i + 1];
                DLRLogger.info("Setting sumoExec: " + this.sumoExec);
                if (!new File(this.sumoExec).exists()) {
                    DLRLogger.severe(String.format("Error: Couldn't find sumo executable (%s). Quitting.", this.sumoExec));
                    System.exit(0);
                }
            }
            if (args[i].equals("-sumocfg") || args[i].equals("-S")) {
                this.sumoConfig = args[i + 1];
                DLRLogger.info("Setting sumoConfig: " + this.sumoConfig);
                if (!new File(this.sumoConfig).exists()) {
                    DLRLogger.severe(String.format("Error: Couldn't find sumo configuration file (%s). Quitting.", this.sumoConfig));
                    System.exit(0);
                }
            }
            if (args[i].equals("-p")) {
                this.pause = true;
            }
            if (args[i].equals("-lisa") || args[i].equals("-l")) {
                this.lisaRestFulServerDir = args[i + 1];
                DLRLogger.info("Setting LISA Server: " + this.lisaRestFulServerDir);
            }
            if (args[i].equals("-lisa-version") || args[i].equals("-L")) {
                Lisa.setVersion(args[i + 1]);
                DLRLogger.info("Setting LISA Version: " + args[i + 1]);
            }
            if (args[i].equals("-log")) {
                this.loggingLevel = args[i + 1];
                DLRLogger.info("Setting logging level: " + this.loggingLevel.toUpperCase());
            }
            if (!args[i].equals("-file") && !args[i].equals("-f")) continue;
            this.lisumFile = args[i + 1];
            DLRLogger.info("Project file: " + this.lisumFile);
            if (new File(this.lisumFile).exists()) continue;
            DLRLogger.severe(String.format("Error: Couldn't find project file (%s). Quitting.", this.lisumFile));
            System.exit(0);
        }
    }

    public void start(String[] args) throws Exception {
        this.readConf(args);
        DLRLogger.setLevel(LogLevel.valueOf(this.loggingLevel.toUpperCase()));
        if (this.lisumFile.isEmpty()) {
            System.err.println("Error: No Lisum file received. Use -f <path_to_file/lisum.xml>. Quitting.");
            return;
        }
        this.ls = new LisumSimulation(this.sumoExec, 9100, this.lisaRestFulServerDir, 9091);
        this.ls.setSumoConfig(this.sumoConfig);
        this.ls.load(new File(this.lisumFile));
        LisumSimulation.InitBeforePlayResponse initBeforePlay = this.ls.initBeforePlay();
        if (initBeforePlay == LisumSimulation.InitBeforePlayResponse.LisaRESTfulServerNotFound) {
            System.err.println(String.format("Error: No Lisa RESTfull server found in localhost:%d. Quitting.", this.lisaPort));
        } else {
            DLRLogger.info("");
            DLRLogger.info("******  Ebene items  ******");
            for (int i = 0; i < Constants.ebeneItems.size(); ++i) {
                DLRLogger.info(String.format("%1$4s", i) + " " + Constants.ebeneItems.get(i));
            }
            DLRLogger.info("");
            DLRLogger.info("******  Available Control Units  ******");
            for (ControlUnitInterface cu : this.ls.getCityInterface().getControlUnits()) {
                DLRLogger.info("> " + cu.getFullName());
                for (SignalProgramInterface sp : cu.getSignalPrograms()) {
                    DLRLogger.info("      o " + sp.getName());
                }
            }
            this.loadDefaults();
            if (this.pause) {
                DLRLogger.info("Project loaded successfully. Start (Y/N)? [Y]");
                int read = System.in.read();
                if (read == 121 || read == 89 || read == 13) {
                    this.start();
                } else {
                    DLRLogger.info("Good bye!");
                }
            } else {
                this.start();
            }
        }
    }

    private void start() {
        new Thread(this.ls.getRunnable()).start();
    }

    private ControlUnitInterface getControlUnit(String name) {
        for (ControlUnitInterface cu : this.ls.getCityInterface().getControlUnits()) {
            if (!cu.getFullName().contains(name.trim())) continue;
            return cu;
        }
        return null;
    }

    private void loadDefaults() {
        try {
            XMLAdmin2 x = new XMLAdmin2().load(this.lisumFile);
            ControlUnitInterface controlUnit = null;
            SignalProgramInterface signalProgram = null;
            boolean coordinated = false;
            int ebene = 0;
            boolean va = false;
            boolean iv = false;
            boolean ov = false;
            for (ControlUnitInterface cu : this.ls.getCityInterface().getControlUnits()) {
                cu.setEnabled(false);
            }
            int count = x.getNode("controlUnits").getNodesCount("controlUnit");
            for (int i = 0; i < count; ++i) {
                XMLNode node = x.getNode("controlUnits").getNode("controlUnit", i);
                String cuName = node.getAttributes().get("lisa").getValue();
                if (!node.hasNode("state")) continue;
                node = x.getNode("controlUnits").getNode("controlUnit", i).getNode("state");
                boolean enabled = node.getAttributes().get("enabled").getValue(0) == 1;
                controlUnit = this.getControlUnit(cuName);
                if (controlUnit != null) {
                    if (!enabled) continue;
                    String programName = node.getAttributes().get("program").getValue();
                    int signalIndex = 0;
                    for (SignalProgramInterface sp : controlUnit.getSignalPrograms()) {
                        if (sp.getName().contains(programName)) {
                            signalProgram = sp;
                            break;
                        }
                        ++signalIndex;
                    }
                    if (signalProgram == null) {
                        DLRLogger.severe("No signal program containing " + programName + " could be found.");
                        return;
                    }
                    controlUnit.setEnabled(true);
                    coordinated = node.getAttributes().get("coordinated").getValue(0) == 1;
                    ebene = node.getAttributes().get("ebene").getValue(0);
                    va = node.getAttributes().get("va").getValue(0) == 1;
                    iv = node.getAttributes().get("iv").getValue(0) == 1;
                    ov = node.getAttributes().get("ov").getValue(0) == 1;
                    controlUnit.setEnabled(true);
                    controlUnit.setEbene(ebene);
                    controlUnit.setCoordinated(coordinated ? 1 : 0);
                    controlUnit.setCurrentSignalProgram(signalIndex);
                    controlUnit.setVA(va);
                    controlUnit.setIV(iv);
                    controlUnit.setOV(ov);
                    continue;
                }
                DLRLogger.severe("Error: Couldn't find control unit " + cuName);
            }
            DLRLogger.info("");
            DLRLogger.info("******  Default states  ******");
            for (int j = 0; j < this.ls.getCityInterface().getControlUnits().length; ++j) {
                controlUnit = this.ls.getCityInterface().getControlUnits()[j];
                DLRLogger.info("> Control unit: " + controlUnit.getFullName() + " (enabled=" + controlUnit.isEnabled() + ")");
                if (!controlUnit.isEnabled()) continue;
                DLRLogger.info("     o Program: " + controlUnit.getCurrentSignalProgram().getName());
                DLRLogger.info("     o Coordinated=" + (controlUnit.getCoordinated() == 1));
                DLRLogger.info("     o Ebene=" + Constants.ebeneItems.get(ebene));
                DLRLogger.info("     o va=" + controlUnit.isVA() + ", iv=" + controlUnit.isIV() + ", \u00f6v=" + controlUnit.isOV());
            }
        }
        catch (MalformedKeyOrNameException | XMLNodeNotFoundException | IOException | SAXException ex) {
            Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
            System.exit(0);
        }
    }

    private String[] cleanArray(String[] args) {
        ArrayList<String> tmp = new ArrayList<String>();
        for (String arg : args) {
            if (arg.trim().isEmpty()) continue;
            tmp.add(arg.trim());
        }
        return tmp.toArray(new String[tmp.size()]);
    }
}

