/*
 * Decompiled with CFR 0.152.
 */
package de.dlr.ts.lisum.simulation;

import de.dlr.ts.utils.xmladmin2.MalformedKeyOrNameException;
import de.dlr.ts.utils.xmladmin2.XMLAdmin2;
import de.dlr.ts.utils.xmladmin2.XMLNode;
import de.dlr.ts.utils.xmladmin2.XMLNodeNotFoundException;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.xml.sax.SAXException;

public class VehicleTypes {
    private final Map<String, VehicleType> types = new HashMap<String, VehicleType>();

    public VehicleType getVehicleType(String name) {
        return this.types.get(name);
    }

    public void load(File configFile) {
        try {
            XMLAdmin2 x = new XMLAdmin2().load(configFile);
            int nodesCount = x.getNodesCount("vType");
            for (int i = 0; i < nodesCount; ++i) {
                XMLNode node = x.getNode("vType", i);
                String id = node.getAttributes().get("id").getValue();
                double length = node.getAttributes().get("length").getValue(0.0);
                this.types.put(id, new VehicleType(id, length));
            }
        }
        catch (MalformedKeyOrNameException | XMLNodeNotFoundException | IOException | SAXException ex) {
            ex.printStackTrace(System.out);
        }
    }

    public static class VehicleType {
        private final String name;
        private final double length;

        public VehicleType(String name, double length) {
            this.name = name;
            this.length = length;
        }

        public String getName() {
            return this.name;
        }

        public double getLength() {
            return this.length;
        }
    }
}

