/*
 * Decompiled with CFR 0.152.
 */
package de.dlr.ts.lisum.sumo;

import de.dlr.ts.lisum.enums.LightColor;
import de.dlr.ts.lisum.simulation.SimulationControlUnits;
import de.tudresden.sumo.cmd.Trafficlight;
import it.polito.appeal.traci.SumoTraciConnection;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

class SumoControlUnit {
    private final List<SignalGroup> signalGroups = new ArrayList<SignalGroup>();
    private final String name;
    private SimulationControlUnits controlUnits;
    private SumoTraciConnection sumoTraciConnection;

    public SumoControlUnit(String name, String[] sumoStrings) {
        this.name = name;
        int phasesCount = sumoStrings[0].length();
        for (int i = 0; i < phasesCount; ++i) {
            SignalGroup sg = new SignalGroup();
            this.signalGroups.add(sg);
        }
    }

    public void setSumoTraciConnection(SumoTraciConnection sumoTraciConnection) {
        this.sumoTraciConnection = sumoTraciConnection;
    }

    private String extractStates(int index, String[] lines) {
        String tmp = "";
        for (String line : lines) {
            tmp = tmp + line.charAt(index);
        }
        return tmp;
    }

    void setControlUnits(SimulationControlUnits controlUnits) {
        this.controlUnits = controlUnits;
    }

    public void executeSimulationStep() {
        for (int j = 0; j < this.signalGroups.size(); ++j) {
            this.signalGroups.get(j).setCurrentLightColor(this.controlUnits.getLightColor(this.name, j));
        }
        this.set();
    }

    private void set() {
        String signalGroupState = "";
        for (SignalGroup signalGroup : this.signalGroups) {
            char sumoCurrentLightColor = signalGroup.getSumoCurrentLightColor();
            signalGroupState = signalGroupState + sumoCurrentLightColor;
        }
        try {
            this.sumoTraciConnection.do_job_set(Trafficlight.setRedYellowGreenState((String)this.name, (String)signalGroupState));
        }
        catch (IOException ex) {
            ex.printStackTrace(System.out);
        }
        catch (Exception ex) {
            Logger.getLogger(SumoControlUnit.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public String getName() {
        return this.name;
    }

    public int getSignalGroupsCount() {
        return this.signalGroups.size();
    }

    public void setLightColor(int signalGroupIndex, LightColor color) {
        this.signalGroups.get(signalGroupIndex).setCurrentLightColor(color);
    }

    public static class SignalGroup {
        private LightColor currentLightColor = LightColor.OFF;

        public void setCurrentLightColor(LightColor currentLightColor) {
            this.currentLightColor = currentLightColor;
        }

        public char getSumoCurrentLightColor() {
            return this.currentLightColor.getSumoCode();
        }
    }
}

