/*
 * Decompiled with CFR 0.152.
 */
package de.dlr.ts.lisum.sumo;

import de.dlr.ts.commons.logger.DLRLogger;
import de.dlr.ts.lisum.sumo.SumoControlUnit;
import de.dlr.ts.utils.xmladmin2.MalformedKeyOrNameException;
import de.dlr.ts.utils.xmladmin2.XMLAdmin2;
import de.dlr.ts.utils.xmladmin2.XMLNode;
import de.dlr.ts.utils.xmladmin2.XMLNodeNotFoundException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.xml.sax.SAXException;

class SumoControlUnits {
    private final List<SumoControlUnit> controlUnits = new ArrayList<SumoControlUnit>();
    private final Map<String, SumoControlUnit> controlUnitsHash = new HashMap<String, SumoControlUnit>();

    public int getCount() {
        return this.controlUnits.size();
    }

    public SumoControlUnit getControlUnit(int index) {
        return this.controlUnits.get(index);
    }

    public void executeSimulationStep() {
        for (int i = 0; i < this.controlUnits.size(); ++i) {
            this.controlUnits.get(i).executeSimulationStep();
        }
    }

    public SumoControlUnit getControlUnit(String name) {
        return this.controlUnitsHash.get(name);
    }

    public SumoControlUnits load(File sumoNetFile) {
        try {
            XMLAdmin2 x = new XMLAdmin2().load(sumoNetFile);
            int tlscount = x.getNodesCount("tlLogic");
            for (int i = 0; i < tlscount; ++i) {
                XMLNode node = x.getNode("tlLogic", i);
                String name = node.getAttributes().get("id").getValue();
                int phasesCount = node.getNodesCount("phase");
                String[] states = new String[phasesCount];
                for (int j = 0; j < phasesCount; ++j) {
                    states[j] = node.getNode("phase", j).getAttributes().get("state").getValue();
                }
                SumoControlUnit scu = new SumoControlUnit(name, states);
                this.controlUnits.add(scu);
                this.controlUnitsHash.put(name, scu);
                DLRLogger.info((Object)this, "Adding control unit " + name + ".");
            }
        }
        catch (MalformedKeyOrNameException | XMLNodeNotFoundException | IOException | SAXException ex) {
            DLRLogger.severe((Object)this, ex);
        }
        return this;
    }
}

