/*
 * Decompiled with CFR 0.152.
 */
package de.dlr.ts.lisum.sumo;

import de.dlr.ts.commons.logger.DLRLogger;
import de.dlr.ts.lisum.interfaces.DetectorInterface;
import de.tudresden.sumo.cmd.Inductionloop;
import de.tudresden.sumo.objects.SumoVehicleData;
import it.polito.appeal.traci.SumoTraciConnection;

class SumoDetector {
    private final String name;
    private DetectorInterface cityDetector;
    private final SumoTraciConnection conn;
    private double lastEntryTime = 0.0;
    private boolean onlyLeave = false;

    public SumoDetector(String name, SumoTraciConnection conn) {
        this.conn = conn;
        this.name = name;
    }

    public String toString() {
        return this.name;
    }

    public void setCityDetector(DetectorInterface cityDetector) {
        this.cityDetector = cityDetector;
    }

    public String getName() {
        return this.name;
    }

    public void executeSimulationStep() throws Exception {
        if (this.cityDetector == null) {
            return;
        }
        SumoVehicleData vehData = (SumoVehicleData)this.conn.do_job_get(Inductionloop.getVehicleData((String)this.name));
        for (SumoVehicleData.VehicleData d : vehData.ll) {
            DLRLogger.finest((Object)this, String.format(" veh=%s len=%s entry=%s leave=%s type=%s", d.vehID, d.length, d.entry_time, d.leave_time, d.typeID));
            double entryTime = d.entry_time;
            double leaveTime = d.leave_time;
            if (entryTime == this.lastEntryTime && leaveTime == -1.0) continue;
            if (!this.onlyLeave) {
                this.onlyLeave = true;
                this.lastEntryTime = entryTime;
                entryTime -= (double)((int)entryTime);
                this.cityDetector.addFlanke((int)(entryTime *= 100.0));
            }
            if (leaveTime == -1.0) continue;
            leaveTime -= (double)((int)leaveTime);
            int leaveTimeInt = (int)(leaveTime *= 100.0);
            if ((leaveTimeInt *= -1) == 0) {
                leaveTimeInt = -1;
            }
            this.cityDetector.addFlanke(leaveTimeInt);
            this.lastEntryTime = 0.0;
            this.onlyLeave = false;
        }
    }
}

