/*
 * Decompiled with CFR 0.152.
 */
package floetteroed.cadyts.calibrators;

import java.io.Serializable;

public class TimedElement
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int MIN_START_TIME_S = 0;
    public static final int MAX_END_TIME_S = 86400;
    private final int startTime_s;
    private final int endTime_s;

    public TimedElement(int startTime_s, int endTime_s) {
        if (startTime_s >= endTime_s) {
            throw new IllegalArgumentException("start time " + startTime_s + " s is not strictly before end time " + endTime_s + " s");
        }
        if (startTime_s < 0) {
            throw new IllegalArgumentException("smallest allowed measurement start time is 0 s");
        }
        if (endTime_s > 86400) {
            throw new IllegalArgumentException("largest allowed measurement end time is 86400 s");
        }
        this.startTime_s = startTime_s;
        this.endTime_s = endTime_s;
    }

    public int getStartTime_s() {
        return this.startTime_s;
    }

    public int getEndTime_s() {
        return this.endTime_s;
    }

    public int getDuration_s() {
        return this.getEndTime_s() - this.getStartTime_s();
    }
}

