/*
 * Decompiled with CFR 0.152.
 */
package floetteroed.cadyts.calibrators.filebased.xml;

import java.util.logging.Logger;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.helpers.DefaultHandler;

class SAXParserThread
extends Thread {
    private static SAXParserThread instance = null;
    private final String fileName;
    private final DefaultHandler handler;

    static synchronized SAXParserThread newInstance(String fileName, DefaultHandler handler) {
        if (instance != null && instance.isAlive()) {
            try {
                Logger.getLogger(SAXParserThread.class.getName()).fine("waiting for previous parser thread to terminate");
                long waitStart_ms = System.currentTimeMillis();
                instance.join();
                Logger.getLogger(SAXParserThread.class.getName()).fine("previous parser thread terminated after " + (System.currentTimeMillis() - waitStart_ms) + " ms");
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        instance = new SAXParserThread(fileName, handler);
        return instance;
    }

    private SAXParserThread(String fileName, DefaultHandler handler) {
        if (fileName == null) {
            throw new IllegalArgumentException("fileName must not be null");
        }
        if (handler == null) {
            throw new IllegalArgumentException("handler must not be null");
        }
        this.fileName = fileName;
        this.handler = handler;
    }

    @Override
    public void run() {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse(this.fileName, this.handler);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

