/*
 * Decompiled with CFR 0.152.
 */
package floetteroed.cadyts.calibrators.sampling;

import floetteroed.cadyts.calibrators.Calibrator;
import floetteroed.cadyts.calibrators.sampling.ChoiceSampler;
import floetteroed.cadyts.calibrators.sampling.ChoiceSamplerFactory;
import floetteroed.cadyts.calibrators.sampling.RecursiveSamplerFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public class SamplingCalibrator<L>
extends Calibrator<L> {
    private static final long serialVersionUID = 1L;
    public static final int DEFAULT_MAX_DRAWS = 20;
    private final Map<Object, ChoiceSampler<L>> samplers = new HashMap<Object, ChoiceSampler<L>>();
    private ChoiceSamplerFactory<L> choiceSamplerFactory = new RecursiveSamplerFactory(this);
    private int maxDraws = 20;

    public SamplingCalibrator(String logFile, Long randomSeed, int timeBinSize_s) {
        super(logFile, randomSeed, timeBinSize_s);
        Logger.getLogger(this.getClass().getName()).info("default maxDraws is " + this.maxDraws);
        Logger.getLogger(this.getClass().getName()).info("default choiceSamplerFactory is " + RecursiveSamplerFactory.class.getSimpleName());
    }

    public void setMaxDraws(int maxDraws) {
        if (maxDraws < 2) {
            throw new IllegalArgumentException("maximum number of draws must be at least 2");
        }
        this.maxDraws = maxDraws;
        Logger.getLogger(this.getClass().getName()).info("set maxDraws to " + this.maxDraws);
    }

    public int getMaxDraws() {
        return this.maxDraws;
    }

    public void setChoiceSamplerFactory(ChoiceSamplerFactory<L> choiceSamplerFactory) {
        if (choiceSamplerFactory == null) {
            throw new IllegalArgumentException("choiceSamplerFactory must not be null");
        }
        this.choiceSamplerFactory = choiceSamplerFactory;
        Logger.getLogger(this.getClass().getName()).info("set choiceSamplerFactory to " + this.choiceSamplerFactory.getClass().getSimpleName());
    }

    public ChoiceSamplerFactory<L> getChoiceSamplerFactory() {
        return this.choiceSamplerFactory;
    }

    public ChoiceSampler<L> getSampler(Object agent) {
        if (agent == null) {
            throw new IllegalArgumentException("reference agent must not be null;");
        }
        ChoiceSampler<L> sampler = this.samplers.get(agent);
        if (sampler == null) {
            sampler = this.getChoiceSamplerFactory().newSampler();
            this.samplers.put(agent, sampler);
        }
        if (this.getIteration() < this.getPreparatoryIterations()) {
            sampler.enforceNextAccept();
        }
        return sampler;
    }
}

