/*
 * Decompiled with CFR 0.152.
 */
package floetteroed.cadyts.demand;

import floetteroed.cadyts.demand.PlanStep;
import floetteroed.utilities.DynamicData;

public class Demand<L>
extends DynamicData<L> {
    private static final long serialVersionUID = 1L;

    public Demand(int startTime_s, int timePeriod_s, int binCnt) {
        super(startTime_s, timePeriod_s, binCnt);
        if (startTime_s < 0) {
            throw new IllegalArgumentException("start time must not be negative");
        }
    }

    public boolean add(PlanStep<L> planStep) {
        int bin = this.bin(planStep.getEntryTime_s());
        if (bin < 0 || bin >= this.getBinCnt()) {
            return false;
        }
        this.add(planStep.getLink(), bin, 1.0);
        return true;
    }

    public boolean add(PlanStep<L> planStep, double weight) {
        int bin = this.bin(planStep.getEntryTime_s());
        if (bin < 0 || bin >= this.getBinCnt()) {
            return false;
        }
        this.add(planStep.getLink(), bin, weight);
        return true;
    }
}

