/*
 * Decompiled with CFR 0.152.
 */
package floetteroed.cadyts.demand;

import floetteroed.cadyts.demand.BasicPlan;
import floetteroed.cadyts.demand.Plan;
import floetteroed.cadyts.demand.PlanStep;

public class PlanBuilder<L> {
    private final boolean countFirstLink;
    private final boolean countLastLink;
    private BasicPlan<L> result;

    public PlanBuilder(boolean countFirstLink, boolean countLastLink) {
        this.countFirstLink = countFirstLink;
        this.countLastLink = countLastLink;
        this.reset();
    }

    public PlanBuilder() {
        this(false, true);
    }

    public void reset() {
        this.result = new BasicPlan();
    }

    public void reset(BasicPlan<L> result) {
        this.result = result;
    }

    public void addEntry(L entryLink, int time_s) {
        if (this.countFirstLink) {
            this.result.addStep(new PlanStep<L>(entryLink, time_s));
        }
    }

    public void addTurn(L toLink, int time_s) {
        this.result.addStep(new PlanStep<L>(toLink, time_s));
    }

    public void addExit(int time_s) {
        if (!this.countLastLink && this.result.size() > 0) {
            this.result.removeLastStep();
        }
    }

    public Plan<L> getResult() {
        this.result.trim();
        return this.result;
    }
}

