/*
 * Decompiled with CFR 0.152.
 */
package floetteroed.cadyts.interfaces.dracula;

import floetteroed.cadyts.calibrators.filebased.ChoiceFileWriter;
import floetteroed.cadyts.calibrators.filebased.FileBasedController;
import floetteroed.cadyts.calibrators.filebased.PopulationFileReader;
import floetteroed.cadyts.interfaces.dracula.DraculaAgent;
import floetteroed.cadyts.interfaces.dracula.DraculaCalibrator;
import floetteroed.cadyts.interfaces.dracula.DraculaChoiceWriter;
import floetteroed.cadyts.interfaces.dracula.DraculaLink;
import floetteroed.cadyts.interfaces.dracula.DraculaMeasurementLoader;
import floetteroed.cadyts.interfaces.dracula.DraculaODMatrixXMLFileIO;
import floetteroed.cadyts.interfaces.dracula.DraculaODRelation;
import floetteroed.cadyts.interfaces.dracula.DraculaPlan;
import floetteroed.cadyts.interfaces.dracula.DraculaPopulation;
import floetteroed.cadyts.interfaces.dracula.DraculaRoutes;
import floetteroed.cadyts.interfaces.dracula.DraculaTravelTimes;
import floetteroed.utilities.DynamicData;
import floetteroed.utilities.commandlineparser.CommandLineParser;
import java.io.IOException;
import java.util.logging.Logger;

public class DraculaController
extends FileBasedController<DraculaCalibrator, DraculaAgent, DraculaPlan, DraculaLink> {
    public static final String WARMUP = "-warmup";
    public static final String BETA_TT = "-betatt";
    public static final String DEMAND_FILE = "-demandfile";
    public static final String FLOW_PREFIX = "-flowprefix";
    public static final String TT_PREFIX = "-ttprefix";
    public static final String INITIAL_TT_FILE = "-initialttfile";
    public static final String DEMAND_PERIODS = "-demandperiods";
    public static final String ODPREFIX_KEY = "-odprefix";
    public static final String DEMANDSCALE_KEY = "-demandscale";
    private DynamicData<DraculaODRelation> odMatrix;

    @Override
    protected DraculaCalibrator newCalibrator(CommandLineParser clp) {
        String logFile = clp.containsKey("-logfile") ? clp.getString("-logfile") : "calibration-log.txt";
        DraculaCalibrator result = new DraculaCalibrator(logFile, clp.getLong("-rndseed"), clp.getInteger("-binsize"));
        return result;
    }

    @Override
    protected void prepareCommandLineParserINIT(CommandLineParser clp) {
        super.prepareCommandLineParserINIT(clp);
        clp.defineParameter(WARMUP, false, Integer.toString(0), "duration of warmup period [s]");
        clp.defineParameter(BETA_TT, true, Double.toString(0.0), "the travel time coefficient [1/s]");
        clp.defineParameter(DEMAND_FILE, true, null, "the initial .DEM file");
        clp.defineParameter(FLOW_PREFIX, false, null, "prefix of flow bookkeeping file");
        clp.defineParameter(TT_PREFIX, false, null, "prefix of travel time bookkeeping file");
        clp.defineParameter(INITIAL_TT_FILE, true, null, "the initial .LTT file");
        clp.defineParameter(DEMAND_PERIODS, false, Integer.toString(1), "number of demand periods");
        clp.defineParameter(ODPREFIX_KEY, false, DraculaCalibrator.DEFAULT_OD_PREFIX, "file prefix for estimated OD matrix");
        clp.defineParameter(DEMANDSCALE_KEY, false, Double.toString(1.0), "demand has been artificially scaled up by this factor");
    }

    @Override
    protected void prepareCalibratorINIT(DraculaCalibrator calibrator, CommandLineParser clp) {
        super.prepareCalibratorINIT(calibrator, clp);
        calibrator.setWarmUp_s(clp.getInteger(WARMUP));
        calibrator.setBetaTT_s(clp.getDouble(BETA_TT));
        calibrator.setDemandPeriods(clp.getInteger(DEMAND_PERIODS));
        calibrator.setRoutes(new DraculaRoutes(clp.getString(DEMAND_FILE), calibrator));
        calibrator.setFlowPrefix(clp.getString(FLOW_PREFIX));
        calibrator.setTravelTimePrefix(clp.getString(TT_PREFIX));
        calibrator.setTravelTimes(new DraculaTravelTimes(clp.getString(INITIAL_TT_FILE), calibrator));
        calibrator.setOdPrefix(clp.getString(ODPREFIX_KEY));
        calibrator.setDemandScale(clp.getDouble(DEMANDSCALE_KEY));
    }

    @Override
    protected void loadMeasurements(DraculaCalibrator calibrator, String measFile) {
        DraculaMeasurementLoader loader = new DraculaMeasurementLoader(calibrator);
        loader.load(measFile);
    }

    @Override
    protected PopulationFileReader<DraculaAgent> newPopulationReader(DraculaCalibrator calibrator, CommandLineParser clp) {
        return new DraculaPopulation(calibrator);
    }

    @Override
    protected ChoiceFileWriter<DraculaAgent, DraculaPlan> newChoiceFileWriter(DraculaCalibrator calibrator) {
        return new DraculaChoiceWriter(calibrator);
    }

    @Override
    protected void selectPlans(DraculaCalibrator calibrator, CommandLineParser clp) throws IOException {
        this.odMatrix = calibrator.getOdPrefix() != null ? new DynamicData(0, calibrator.getTimeBinSize_s(), (int)Math.ceil(86400.0 / (double)calibrator.getTimeBinSize_s())) : null;
        super.selectPlans(calibrator, clp);
        if (this.odMatrix != null) {
            new DraculaODMatrixXMLFileIO().write(calibrator.getOdPrefix() + calibrator.getIteration() + ".xml", this.odMatrix);
            this.odMatrix = null;
        }
    }

    @Override
    protected void afterChoice(DraculaCalibrator calibrator, DraculaAgent agent, DraculaPlan plan) {
        if (this.odMatrix != null) {
            for (int i = 0; i < agent.getPlans().size(); ++i) {
                DraculaODRelation key;
                double moveProb = 0.0;
                DraculaPlan trip = (DraculaPlan)agent.getPlans().get(i);
                if (!((DraculaPlan)agent.getPlans().get(i)).isStayAtHome()) {
                    moveProb += calibrator.getLastChoiceProb(i);
                }
                if ((key = trip.getOD()) == null) continue;
                this.odMatrix.add(key, this.odMatrix.bin(trip.getDepartureTime_s()), moveProb);
            }
        }
    }

    @Override
    protected void update(DraculaCalibrator calibrator, CommandLineParser clp) {
        DraculaTravelTimes travelTimes = new DraculaTravelTimes(clp.getString("-netfile"), calibrator);
        calibrator.setTravelTimes(travelTimes);
        calibrator.afterNetworkLoading(travelTimes);
    }

    public static void main(String[] args) throws Exception {
        StringBuffer msg = new StringBuffer("processing call: ");
        if (args != null) {
            for (String arg : args) {
                msg.append(arg);
                msg.append(" ");
            }
        }
        Logger.getLogger(DraculaController.class.getName()).info(msg.toString());
        try {
            new DraculaController().run(args);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

