/*
 * Decompiled with CFR 0.152.
 */
package floetteroed.cadyts.interfaces.dracula;

import floetteroed.cadyts.demand.PlanChoiceModel;
import floetteroed.cadyts.interfaces.dracula.DraculaCalibrator;
import floetteroed.cadyts.interfaces.dracula.DraculaLink;
import floetteroed.cadyts.interfaces.dracula.DraculaPlan;
import floetteroed.utilities.math.MathHelpers;
import floetteroed.utilities.math.MultinomialLogit;
import floetteroed.utilities.math.Vector;
import java.util.List;
import java.util.logging.Logger;

class DraculaPlanChoiceModel
implements PlanChoiceModel<DraculaPlan> {
    private final DraculaCalibrator calibrator;
    private final double stayAtHomeProb;

    DraculaPlanChoiceModel(DraculaCalibrator calibrator) {
        if (calibrator == null) {
            throw new IllegalArgumentException("calibrator is null");
        }
        this.calibrator = calibrator;
        this.stayAtHomeProb = (calibrator.getDemandScale() - 1.0) / calibrator.getDemandScale();
    }

    @Override
    public Vector getChoiceProbabilities(List<? extends DraculaPlan> plans) {
        MultinomialLogit mnl = new MultinomialLogit(plans.size() - 1, 1);
        mnl.setCoefficient(0, this.calibrator.getBetaTT_s());
        for (int i = 0; i < plans.size() - 1; ++i) {
            DraculaPlan plan = plans.get(i);
            if (plan.isStayAtHome()) {
                Logger.getLogger(this.getClass().getName()).warning("encountered stay-at-home plan before last position in plan list");
            }
            double tt_s = 0.0;
            for (DraculaLink link : plan.getRoute().getLinks()) {
                tt_s += this.calibrator.getTravelTimes().getTT_s(link, plan.getDepartureTime_s() + MathHelpers.round(tt_s));
            }
            mnl.setAttribute(i, 0, tt_s);
        }
        DraculaPlan lastPlan = plans.get(plans.size() - 1);
        if (!lastPlan.isStayAtHome()) {
            Logger.getLogger(this.getClass().getName()).warning("last plan in list is no stay-at-home plan");
        }
        Vector result = mnl.getProbs().copyEnlarged(1);
        result.mult(1.0 - this.stayAtHomeProb);
        result.set(result.size() - 1, this.stayAtHomeProb);
        return result;
    }
}

