/*
 * Decompiled with CFR 0.152.
 */
package floetteroed.cadyts.interfaces.dracula;

import floetteroed.cadyts.calibrators.filebased.PopulationFileReader;
import floetteroed.cadyts.interfaces.dracula.DraculaAgent;
import floetteroed.cadyts.interfaces.dracula.DraculaCalibrator;
import floetteroed.cadyts.interfaces.dracula.DraculaODRelation;
import floetteroed.cadyts.interfaces.dracula.DraculaPlan;
import floetteroed.cadyts.interfaces.dracula.DraculaPlanChoiceModel;
import floetteroed.cadyts.interfaces.dracula.DraculaRoute;
import floetteroed.cadyts.interfaces.dracula.DraculaRoutes;
import floetteroed.cadyts.interfaces.dracula.DraculaTravelTimes;
import floetteroed.utilities.tabularfileparser.TabularFileHandler;
import floetteroed.utilities.tabularfileparser.TabularFileParser;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;

class DraculaPopulation
implements TabularFileHandler,
PopulationFileReader<DraculaAgent> {
    private static final int ID_INDEX = 0;
    private static final int DPT_TIME_INDEX = 1;
    private static final int ROUTE_INDEX = 2;
    private static final int MISC_START_INDEX = 3;
    private final DraculaCalibrator calibrator;
    private final Map<Long, DraculaAgent> id2agent = new LinkedHashMap<Long, DraculaAgent>();

    DraculaPopulation(DraculaCalibrator calibrator) {
        if (calibrator == null) {
            throw new IllegalArgumentException("calibrator is null");
        }
        this.calibrator = calibrator;
    }

    @Override
    public Iterable<DraculaAgent> getPopulationSource(String populationFile) {
        this.id2agent.clear();
        TabularFileParser parser = new TabularFileParser();
        parser.setDelimiterRegex("\\s");
        parser.setMinRowLength(3);
        try {
            parser.parse(populationFile, this);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this.id2agent.values();
    }

    @Override
    public void startDocument() {
    }

    @Override
    public void endDocument() {
    }

    @Override
    public String preprocess(String line) {
        return line;
    }

    @Override
    public void startRow(String[] row) {
        long agentId = Long.parseLong(row[0]);
        int dptTime_s = this.calibrator.getWarmUp_s() + (int)Math.round(Double.parseDouble(row[1]));
        long routeId = Long.parseLong(row[2]);
        String[] misc = Arrays.copyOfRange(row, 3, row.length);
        DraculaODRelation od = this.calibrator.getRoutes().getRoute(routeId).getOD();
        DraculaPlanChoiceModel choiceModel = new DraculaPlanChoiceModel(this.calibrator);
        DraculaAgent agent = new DraculaAgent(agentId, choiceModel, od, dptTime_s, misc);
        for (DraculaRoute route : agent.getOD().getRoutes()) {
            DraculaPlan plan = new DraculaPlan(route, dptTime_s, this.calibrator.newPlanBuilder(), this.calibrator.getTravelTimes());
            agent.addPlan(plan);
        }
        DraculaRoute stayAtHomeRoute = new DraculaRoute(0L, od);
        DraculaPlan stayAtHomePlan = new DraculaPlan(stayAtHomeRoute, dptTime_s, this.calibrator.newPlanBuilder(), null);
        agent.addPlan(stayAtHomePlan);
        this.id2agent.put(agentId, agent);
    }

    public static void main(String[] args) {
        DraculaCalibrator calibrator = new DraculaCalibrator(null, null, 3600);
        DraculaRoutes routes = new DraculaRoutes("C:\\dracula\\net1\\net1.dem", calibrator);
        System.out.println("LOADED ROUTES FROM .DEM FILE");
        calibrator.setRoutes(routes);
        DraculaTravelTimes travelTimes = new DraculaTravelTimes("C:\\dracula\\net1\\net1.ltt", calibrator);
        calibrator.setTravelTimes(travelTimes);
        System.out.println("LOADED TRAVEL TIMES FROM .LTT FILE");
        DraculaPopulation r = new DraculaPopulation(calibrator);
        for (DraculaAgent agent : r.getPopulationSource("C:\\dracula\\net1\\net1-initial.veh")) {
            System.out.println(agent);
        }
        System.out.println("LOADED TRAVEL DEMAND FROM .VEH FILE");
        System.out.println("DONE");
    }
}

