/*
 * Decompiled with CFR 0.152.
 */
package floetteroed.cadyts.interfaces.dracula;

import floetteroed.cadyts.interfaces.dracula.DraculaCalibrator;
import floetteroed.cadyts.interfaces.dracula.DraculaLink;
import floetteroed.cadyts.interfaces.dracula.DraculaRoute;
import floetteroed.cadyts.interfaces.dracula.DraculaRoutes;
import floetteroed.cadyts.measurements.SingleLinkMeasurement;
import floetteroed.cadyts.supply.SimResults;
import floetteroed.utilities.DynamicData;
import floetteroed.utilities.DynamicDataXMLFileIO;
import floetteroed.utilities.math.MathHelpers;
import floetteroed.utilities.tabularfileparser.TabularFileHandler;
import floetteroed.utilities.tabularfileparser.TabularFileParser;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.logging.Logger;

class DraculaTravelTimes
implements TabularFileHandler,
SimResults<DraculaLink> {
    private static final long serialVersionUID = 1L;
    private static final String START_TAG = "22222";
    private static final String END_TAG = "99999";
    private static final int ROUTE_ID_INDEX = 3;
    private static final int DEPARTURE_TIME_INDEX = 10;
    private static final int ARRIVAL_TIME_INDEX = 11;
    private static final int LINK_COUNT_INDEX = 12;
    private static final int FIRST_TT_INDEX = 13;
    private final DraculaCalibrator calibrator;
    private final Map<DraculaLink, Double> minTravelTime_s;
    private final DynamicData<DraculaLink> travelTimeSum_s;
    private final DynamicData<DraculaLink> entryCount;

    DraculaTravelTimes(String travelTimeFileName, DraculaCalibrator calibrator) {
        if (travelTimeFileName == null) {
            throw new IllegalArgumentException("travel time file name is null");
        }
        if (calibrator == null) {
            throw new IllegalArgumentException("calibrator is null");
        }
        if (calibrator.getRoutes() == null) {
            throw new IllegalArgumentException("no routes in calibrator");
        }
        this.calibrator = calibrator;
        int binCnt = (int)Math.ceil(86400.0 / (double)calibrator.getTimeBinSize_s());
        this.travelTimeSum_s = new DynamicData(0, calibrator.getTimeBinSize_s(), binCnt);
        this.entryCount = new DynamicData(0, calibrator.getTimeBinSize_s(), binCnt);
        this.minTravelTime_s = calibrator.getMinTravelTimes();
        TabularFileParser parser = new TabularFileParser();
        parser.setStartTag(START_TAG);
        parser.setEndTag(END_TAG);
        parser.setDelimiterRegex("\\s");
        parser.setMinRowLength(14);
        try {
            parser.parse(travelTimeFileName, this);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (calibrator.getFlowPrefix() != null) {
            DynamicDataXMLFileIO<DraculaLink> flowWriter = new DynamicDataXMLFileIO<DraculaLink>(){
                private static final long serialVersionUID = 1L;

                @Override
                protected String key2attrValue(DraculaLink key) {
                    return Integer.toString(key.getIndex());
                }

                @Override
                protected DraculaLink attrValue2key(String string) {
                    throw new UnsupportedOperationException();
                }
            };
            String flowFileName = calibrator.getFlowPrefix() + calibrator.getIteration() + ".xml";
            try {
                flowWriter.write(flowFileName, this.entryCount);
            }
            catch (IOException e) {
                Logger.getLogger(this.getClass().getName()).warning("could not write flow file: " + flowFileName);
            }
        }
    }

    private void updateTT_s(DraculaLink link, int time_s, double tt_s) {
        Double oldMinTT_s = this.minTravelTime_s.get(link);
        if (oldMinTT_s == null || tt_s < oldMinTT_s) {
            this.minTravelTime_s.put(link, tt_s);
        }
        int bin = Math.max(0, Math.min(this.travelTimeSum_s.bin(time_s), this.travelTimeSum_s.getBinCnt() - 1));
        this.travelTimeSum_s.add(link, bin, tt_s);
        this.entryCount.add(link, bin, 1.0);
    }

    double getTT_s(DraculaLink link, int time_s) {
        int bin = Math.max(0, Math.min(this.entryCount.bin(time_s), this.entryCount.getBinCnt() - 1));
        double count = this.entryCount.getBinValue(link, bin);
        if (count > 0.0) {
            return this.travelTimeSum_s.getBinValue(link, bin) / count;
        }
        Double minTT_s = this.minTravelTime_s.get(link);
        return minTT_s != null ? minTT_s : 0.0;
    }

    @Override
    public void startDocument() {
    }

    @Override
    public String preprocess(String line) {
        return line;
    }

    @Override
    public void startRow(String[] row) {
        Long routeId = Long.parseLong(row[3]);
        double dptTime_s = Double.parseDouble(row[10]);
        double arrTime_s = Double.parseDouble(row[11]);
        int linkCnt = Integer.parseInt(row[12]);
        ArrayList<Double> linkTTList_s = new ArrayList<Double>(linkCnt);
        for (int i = 13; i < 13 + 2 * linkCnt; i += 2) {
            linkTTList_s.add(Double.parseDouble(row[i]));
        }
        DraculaRoute route = this.calibrator.getRoutes().getRoute(routeId);
        if (route == null) {
            Logger.getLogger(this.getClass().getName()).warning("unknown route " + routeId + " -- ignoring trip");
            return;
        }
        if (route.getLinks().size() != linkCnt) {
            Logger.getLogger(this.getClass().getName()).warning("inconsistent length of route " + routeId + " -- some data may be lost");
        }
        double totalTT_s = 0.0;
        for (int i = 0; i < Math.min(route.getLinks().size(), linkCnt); ++i) {
            DraculaLink link = route.getLinks().get(i);
            double tt_s = (Double)linkTTList_s.get(i);
            this.updateTT_s(link, MathHelpers.round(dptTime_s + totalTT_s), tt_s);
            totalTT_s += tt_s;
        }
        double err = dptTime_s + totalTT_s - arrTime_s;
        if (Math.abs(err) > 1.0) {
            Logger.getLogger(this.getClass().getName()).warning("travel time error of " + err + " s on route " + routeId);
        }
    }

    @Override
    public void endDocument() {
        if (this.calibrator.getTravelTimePrefix() != null) {
            DynamicData<DraculaLink> tts = new DynamicData<DraculaLink>(this.entryCount.getStartTime_s(), this.entryCount.getBinSize_s(), this.entryCount.getBinCnt());
            for (DraculaLink link : this.minTravelTime_s.keySet()) {
                for (int bin = 0; bin < tts.getBinCnt(); ++bin) {
                    tts.put(link, bin, this.getTT_s(link, tts.binStart_s(bin)));
                }
            }
            DynamicDataXMLFileIO<DraculaLink> writer = new DynamicDataXMLFileIO<DraculaLink>(){
                private static final long serialVersionUID = 1L;

                @Override
                protected String key2attrValue(DraculaLink key) {
                    return Integer.toString(key.getIndex());
                }

                @Override
                protected DraculaLink attrValue2key(String string) {
                    throw new UnsupportedOperationException();
                }
            };
            String ttFileName = this.calibrator.getTravelTimePrefix() + this.calibrator.getIteration() + ".xml";
            try {
                writer.write(ttFileName, tts);
            }
            catch (IOException e) {
                Logger.getLogger(this.getClass().getName()).warning("could not write travel time file: " + ttFileName);
            }
        }
    }

    @Override
    public double getSimValue(DraculaLink link, int startTime_s, int endTime_s, SingleLinkMeasurement.TYPE type) {
        if (!SingleLinkMeasurement.TYPE.FLOW_VEH_H.equals((Object)type)) {
            throw new IllegalArgumentException("current implementation only allows for data type " + SingleLinkMeasurement.TYPE.FLOW_VEH_H);
        }
        double dur_h = 2.777777777777778E-4 * (double)(endTime_s - startTime_s);
        return this.entryCount.getSum(link, startTime_s, endTime_s) / dur_h;
    }

    public static void main(String[] args) {
        DraculaCalibrator calibrator = new DraculaCalibrator(null, 0L, 3600);
        DraculaRoutes routes = new DraculaRoutes("C:\\dracula\\otley\\otley.dem", calibrator);
        System.out.println("LOADED ROUTES FROM .DEM FILE");
        calibrator.setRoutes(routes);
        DraculaTravelTimes dTT = new DraculaTravelTimes("C:\\dracula\\otley\\otley.ltt", calibrator);
        System.out.println("LOADED TRAVEL TIMES FROM .LTT FILE");
        System.out.println("number of links = " + dTT.minTravelTime_s.keySet().size());
        for (DraculaLink link : dTT.minTravelTime_s.keySet()) {
            System.out.println("link = " + link + ", value = " + dTT.minTravelTime_s.get(link));
        }
        System.out.println("DONE");
    }
}

