/*
 * Decompiled with CFR 0.152.
 */
package floetteroed.cadyts.interfaces.sumo;

import floetteroed.cadyts.calibrators.filebased.ChoiceFileWriter;
import floetteroed.cadyts.calibrators.filebased.FileBasedController;
import floetteroed.cadyts.calibrators.filebased.PopulationFileReader;
import floetteroed.cadyts.calibrators.filebased.xml.XMLPopulationFileReader;
import floetteroed.cadyts.demand.ODRelation;
import floetteroed.cadyts.interfaces.defaults.BasicMeasurementLoaderStringLinks;
import floetteroed.cadyts.interfaces.sumo.SumoAgent;
import floetteroed.cadyts.interfaces.sumo.SumoAgentCloner;
import floetteroed.cadyts.interfaces.sumo.SumoCalibrator;
import floetteroed.cadyts.interfaces.sumo.SumoChoiceWriter;
import floetteroed.cadyts.interfaces.sumo.SumoFlowLoader;
import floetteroed.cadyts.interfaces.sumo.SumoODWriter;
import floetteroed.cadyts.interfaces.sumo.SumoPlan;
import floetteroed.cadyts.interfaces.sumo.SumoPopulationHandler;
import floetteroed.utilities.DynamicData;
import floetteroed.utilities.commandlineparser.CommandLineParser;
import java.io.IOException;
import java.util.logging.Logger;

public class SumoController
extends FileBasedController<SumoCalibrator, SumoAgent, SumoPlan, String> {
    public static final String DEMANDSCALE_KEY = "-demandscale";
    public static final String OVERRIDETT_KEY = "-overridett";
    public static final String FMAPREFIX_KEY = "-fmaprefix";
    public static final String CLONEPOSTFIX_KEY = "-clonepostfix";
    private DynamicData<ODRelation<String>> odMatrix = null;

    @Override
    protected SumoCalibrator newCalibrator(CommandLineParser clp) {
        String logFile = clp.containsKey("-logfile") ? clp.getString("-logfile") : "calibration-log.txt";
        SumoCalibrator result = new SumoCalibrator(logFile, clp.getLong("-rndseed"), clp.getInteger("-binsize"));
        return result;
    }

    @Override
    protected void prepareCommandLineParserINIT(CommandLineParser clp) {
        super.prepareCommandLineParserINIT(clp);
        clp.defineParameter(DEMANDSCALE_KEY, false, Double.toString(1.0), "demand is artifically scaled up by this factor");
        clp.defineParameter(OVERRIDETT_KEY, false, Boolean.toString(false), "if plan travel times are to be overriden from dump file travel times");
        clp.defineParameter(FMAPREFIX_KEY, false, null, "prefix of OD matrix files in visum format");
        clp.defineParameter(CLONEPOSTFIX_KEY, false, "-CLONE", "postfix attached to clone ids");
    }

    @Override
    protected void prepareCalibratorINIT(SumoCalibrator calibrator, CommandLineParser clp) {
        super.prepareCalibratorINIT(calibrator, clp);
        calibrator.setDemandScale(clp.getDouble(DEMANDSCALE_KEY));
        calibrator.setOverrideTravelTimes(clp.getBoolean(OVERRIDETT_KEY));
        calibrator.setFmaPrefix(clp.getString(FMAPREFIX_KEY));
        calibrator.setClonePostfix(clp.getString(CLONEPOSTFIX_KEY));
    }

    @Override
    protected void loadMeasurements(SumoCalibrator calibrator, String measFile) {
        if (measFile == null) {
            Logger.getLogger(this.getClass().getName()).warning("no measurement file specified");
            return;
        }
        new BasicMeasurementLoaderStringLinks(calibrator).load(measFile);
    }

    @Override
    protected PopulationFileReader<SumoAgent> newPopulationReader(SumoCalibrator calibrator, CommandLineParser clp) {
        XMLPopulationFileReader<SumoAgent> reader = new XMLPopulationFileReader<SumoAgent>();
        SumoPopulationHandler populationHandler = new SumoPopulationHandler(calibrator.newPlanBuilder(), calibrator.getTravelTimes(), calibrator.getDemandScale());
        reader.setPopulationHandler(populationHandler);
        if (calibrator.getDemandScale() > 1.0) {
            SumoAgentCloner cloner = new SumoAgentCloner(calibrator.newPlanBuilder());
            cloner.run(clp.getString("-choicesetfile").split("\\,"), calibrator.getDemandScale());
            populationHandler.setClonedAgentIDs(cloner.getClonedAgentIDs(), calibrator.getClonePostfix());
        }
        return reader;
    }

    @Override
    protected ChoiceFileWriter<SumoAgent, SumoPlan> newChoiceFileWriter(SumoCalibrator calibrator) {
        return new SumoChoiceWriter();
    }

    @Override
    protected void selectPlans(SumoCalibrator calibrator, CommandLineParser clp) throws IOException {
        this.odMatrix = calibrator.getFmaPrefix() != null ? new DynamicData(0, calibrator.getTimeBinSize_s(), (int)Math.ceil(86400.0 / (double)calibrator.getTimeBinSize_s())) : null;
        super.selectPlans(calibrator, clp);
        if (calibrator.getFmaPrefix() != null) {
            try {
                Logger.getLogger(this.getClass().getName()).info("writing files " + calibrator.getFmaPrefix() + "[..]");
                new SumoODWriter().write(this.odMatrix, calibrator.getFmaPrefix());
            }
            catch (IOException e) {
                Logger.getLogger(this.getClass().getName()).warning("unable to write files " + calibrator.getFmaPrefix() + "[..]");
            }
        }
    }

    @Override
    protected void afterChoice(SumoCalibrator calibrator, SumoAgent agent, SumoPlan plan) {
        super.afterChoice(calibrator, agent, plan);
        if (this.odMatrix != null) {
            for (int i = 0; i < agent.getPlans().size(); ++i) {
                ODRelation<String> key;
                double moveProb = 0.0;
                if (!((SumoPlan)agent.getPlans().get(i)).isStayAtHome()) {
                    moveProb += calibrator.getLastChoiceProb(i);
                }
                if ((key = agent.getODRelation()) == null) continue;
                this.odMatrix.add(key, this.odMatrix.bin(agent.getDptTime_s()), moveProb);
            }
        }
    }

    @Override
    protected void update(SumoCalibrator calibrator, CommandLineParser clp) {
        if (clp.getString("-netfile") == null) {
            Logger.getLogger(this.getClass().getName()).warning("no network conditions file specified");
            return;
        }
        SumoFlowLoader loader = new SumoFlowLoader(calibrator);
        loader.load(clp.getString("-netfile"));
        calibrator.setFlowAnalysisFile(clp.getString("-flowfile"));
        calibrator.afterNetworkLoading(loader.getResults());
        calibrator.overrideTravelTimes(loader.getTravelTimes());
    }

    public static void main(String[] args) {
        StringBuffer msg = new StringBuffer("processing call: ");
        if (args != null) {
            for (String arg : args) {
                msg.append(arg);
                msg.append(" ");
            }
        }
        Logger.getLogger(SumoController.class.getName()).info(msg.toString());
        try {
            new SumoController().run(args);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

